/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParserDefinition;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;

public class GrFileStub
extends PsiFileStubImpl<GroovyFile> {
    private final String @NotNull [] myAnnotations;
    private final StringRef myName;
    private final boolean isScript;

    public GrFileStub(GroovyFile file) {
        super((PsiFile)file);
        this.myName = StringRef.fromString((String)file.getViewProvider().getVirtualFile().getNameWithoutExtension());
        this.isScript = file.isScript();
        GrPackageDefinition definition = file.getPackageDefinition();
        this.myAnnotations = definition != null ? GrStubUtils.getAnnotationNames(definition) : ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public GrFileStub(StringRef name, boolean isScript, String @NotNull [] annotations2) {
        super(null);
        this.myName = name;
        this.isScript = isScript;
        this.myAnnotations = annotations2;
    }

    @NotNull
    public IStubFileElementType getType() {
        return GroovyParserDefinition.GROOVY_FILE;
    }

    public StringRef getName() {
        return this.myName;
    }

    public boolean isScript() {
        return this.isScript;
    }

    public String @NotNull [] getAnnotations() {
        return this.myAnnotations;
    }
}

