/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiFilePattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyAssignmentExpressionPattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyBinaryExpressionPattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyElementPattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyFieldPattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyMethodCallPattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyNamedArgumentPattern;

public class GroovyPatterns
extends PsiJavaPatterns {
    public static GroovyElementPattern groovyElement() {
        return new GroovyElementPattern.Capture<GroovyPsiElement>(GroovyPsiElement.class);
    }

    public static GroovyBinaryExpressionPattern groovyBinaryExpression() {
        return new GroovyBinaryExpressionPattern();
    }

    public static GroovyAssignmentExpressionPattern groovyAssignmentExpression() {
        return new GroovyAssignmentExpressionPattern();
    }

    public static GroovyElementPattern.Capture<GrLiteral> groovyLiteralExpression() {
        return GroovyPatterns.groovyLiteralExpression(null);
    }

    public static GroovyElementPattern.Capture<GrLiteral> groovyLiteralExpression(final @Nullable ElementPattern value2) {
        return new GroovyElementPattern.Capture<GrLiteral>(new InitialPatternCondition<GrLiteral>(GrLiteral.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof GrLiteral && (value2 == null || value2.accepts(((GrLiteral)o).getValue(), context));
            }
        });
    }

    public static PsiMethodPattern grLightMethod(final @NotNull Object key) {
        return (PsiMethodPattern)PsiJavaPatterns.psiMethod().with((PatternCondition)new PatternCondition<PsiMethod>("GrLightMethodBuilder"){

            public boolean accepts(@NotNull PsiMethod method, ProcessingContext context) {
                return GrLightMethodBuilder.checkKind((PsiElement)method, key);
            }
        });
    }

    public static GroovyElementPattern.Capture<GroovyPsiElement> rightOfAssignment(final ElementPattern<? extends GroovyPsiElement> value2, final GroovyAssignmentExpressionPattern assignment) {
        return new GroovyElementPattern.Capture<GroovyPsiElement>(new InitialPatternCondition<GroovyPsiElement>(GroovyPsiElement.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (!(o instanceof GroovyPsiElement)) {
                    return false;
                }
                PsiElement parent2 = ((GroovyPsiElement)o).getParent();
                if (!(parent2 instanceof GrAssignmentExpression)) {
                    return false;
                }
                if (((GrAssignmentExpression)parent2).getRValue() != o) {
                    return false;
                }
                return assignment.accepts(parent2, context) && value2.accepts(o, context);
            }
        });
    }

    public static GroovyElementPattern.Capture<GrLiteralImpl> stringLiteral() {
        return new GroovyElementPattern.Capture<GrLiteralImpl>(new InitialPatternCondition<GrLiteralImpl>(GrLiteralImpl.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                if (!(o instanceof GrLiteral)) {
                    return false;
                }
                return ((GrLiteral)o).isString();
            }
        });
    }

    public static GroovyElementPattern.Capture<GrLiteralImpl> namedArgumentStringLiteral() {
        return (GroovyElementPattern.Capture)GroovyPatterns.stringLiteral().withParent((ElementPattern)GroovyPatterns.namedArgument());
    }

    public static GroovyNamedArgumentPattern namedArgument() {
        return new GroovyNamedArgumentPattern();
    }

    public static GroovyElementPattern.Capture<GrArgumentLabel> namedArgumentLabel(final @Nullable ElementPattern<String> namePattern) {
        return new GroovyElementPattern.Capture<GrArgumentLabel>(new InitialPatternCondition<GrArgumentLabel>(GrArgumentLabel.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                IElementType elementType;
                PsiElement nameElement;
                if (o instanceof GrArgumentLabel && (nameElement = ((GrArgumentLabel)o).getNameElement()) instanceof LeafPsiElement && ((elementType = ((LeafPsiElement)nameElement).getElementType()) == GroovyTokenTypes.mIDENT || "java.lang.String".equals(TypesUtil.getBoxedTypeName(elementType)))) {
                    return namePattern == null || namePattern.accepts((Object)((GrArgumentLabel)o).getName());
                }
                return false;
            }
        });
    }

    public static GroovyMethodCallPattern methodCall(ElementPattern<String> names, final String className) {
        return GroovyMethodCallPattern.INSTANCE.withMethodName(names).withMethod((ElementPattern<? extends PsiMethod>)GroovyPatterns.psiMethod().with((PatternCondition)new PatternCondition<PsiMethod>("psiMethodClassNameCondition"){

            public boolean accepts(@NotNull PsiMethod psiMethod, ProcessingContext context) {
                PsiClass containingClass = psiMethod.getContainingClass();
                return containingClass != null && InheritanceUtil.isInheritor((PsiClass)containingClass, (String)className);
            }
        }));
    }

    public static GroovyMethodCallPattern methodCall() {
        return GroovyMethodCallPattern.INSTANCE;
    }

    public static PsiFilePattern.Capture<GroovyFile> groovyScript() {
        return new PsiFilePattern.Capture((InitialPatternCondition)new InitialPatternCondition<GroovyFile>(GroovyFile.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof GroovyFileBase && ((GroovyFileBase)o).isScript();
            }
        });
    }

    public static GroovyFieldPattern grField() {
        return new GroovyFieldPattern();
    }
}

