/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;

public class GroovyElementPattern<T extends GroovyPsiElement, Self extends GroovyElementPattern<T, Self>>
extends PsiJavaElementPattern<T, Self> {
    public GroovyElementPattern(Class<T> aClass) {
        super(aClass);
    }

    public GroovyElementPattern(@NotNull InitialPatternCondition<T> condition) {
        super(condition);
    }

    @NotNull
    public Self methodCallParameter(final int index, final ElementPattern<? extends PsiMethod> methodPattern) {
        final PsiNamePatternCondition nameCondition = (PsiNamePatternCondition)ContainerUtil.findInstance((Iterable)methodPattern.getCondition().getConditions(), PsiNamePatternCondition.class);
        return (Self)((Object)((GroovyElementPattern)this.with(new PatternCondition<T>("methodCallParameter"){

            public boolean accepts(@NotNull T literal, ProcessingContext context) {
                PsiElement parent2 = literal.getParent();
                if (parent2 instanceof GrArgumentList) {
                    if (!(literal instanceof GrExpression)) {
                        return false;
                    }
                    GrArgumentList psiExpressionList = (GrArgumentList)parent2;
                    if (psiExpressionList.getExpressionArgumentIndex((GrExpression)literal) != index) {
                        return false;
                    }
                    PsiElement element = psiExpressionList.getParent();
                    if (element instanceof GrCall) {
                        GrExpression expression;
                        GroovyPsiElement groovyPsiElement = element instanceof GrMethodCall ? ((GrMethodCall)element).getInvokedExpression() : (expression = element instanceof GrNewExpression ? ((GrNewExpression)element).getReferenceElement() : null);
                        if (expression instanceof GrReferenceElement) {
                            String methodName;
                            GrReferenceElement ref2 = (GrReferenceElement)((Object)expression);
                            if (nameCondition != null && "withName".equals(nameCondition.getDebugMethodName()) && (methodName = ref2.getReferenceName()) != null && !nameCondition.getNamePattern().accepts((Object)methodName, context)) {
                                return false;
                            }
                            for (GroovyResolveResult result2 : ref2.multiResolve(false)) {
                                PsiElement psiElement = result2.getElement();
                                if (!methodPattern.accepts((Object)psiElement, context)) continue;
                                return true;
                            }
                        }
                    }
                }
                return false;
            }
        })));
    }

    @NotNull
    public Self regExpOperatorArgument() {
        return (Self)((Object)((GroovyElementPattern)this.with(new PatternCondition<T>("regExpOperatorArg"){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                PsiElement parent2 = t.getParent();
                return parent2 instanceof GrUnaryExpression && ((GrUnaryExpression)parent2).getOperationTokenType() == GroovyTokenTypes.mBNOT || parent2 instanceof GrBinaryExpression && t == ((GrBinaryExpression)parent2).getRightOperand() && ((GrBinaryExpression)parent2).getOperationTokenType() == GroovyTokenTypes.mREGEX_FIND || parent2 instanceof GrBinaryExpression && t == ((GrBinaryExpression)parent2).getRightOperand() && ((GrBinaryExpression)parent2).getOperationTokenType() == GroovyTokenTypes.mREGEX_MATCH;
            }
        })));
    }

    public static class Capture<T extends GroovyPsiElement>
    extends GroovyElementPattern<T, Capture<T>> {
        public Capture(Class<T> aClass) {
            super(aClass);
        }

        public Capture(@NotNull InitialPatternCondition<T> condition) {
            super(condition);
        }
    }
}

