/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.types;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiListLikeElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;

public class GrTypeArgumentListImpl
extends GroovyPsiElementImpl
implements GrTypeArgumentList,
PsiListLikeElement {
    public GrTypeArgumentListImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitTypeArgumentList(this);
    }

    public String toString() {
        return "Type arguments";
    }

    @Override
    public int getTypeArgumentCount() {
        return PsiTreeUtil.countChildrenOfType((PsiElement)this, GrTypeElement.class);
    }

    @Override
    public GrTypeElement[] getTypeArgumentElements() {
        return (GrTypeElement[])this.findChildrenByClass(GrTypeElement.class);
    }

    @Override
    public PsiType[] getTypeArguments() {
        GrTypeElement[] elements = this.getTypeArgumentElements();
        if (elements.length == 0) {
            return PsiType.EMPTY_ARRAY;
        }
        PsiType[] result2 = PsiType.createArray((int)elements.length);
        for (int i2 = 0; i2 < elements.length; ++i2) {
            result2[i2] = elements[i2].getType();
        }
        return result2;
    }

    @Override
    public boolean isDiamond() {
        return this.findChildByClass(GrTypeElement.class) == null;
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        if (first == last && first.getPsi() instanceof GrTypeElement) {
            if (anchor == null) {
                anchor = this.getLastChild().getNode();
                before = true;
            }
            if (this.getTypeArgumentElements().length > 0) {
                if (before == null || before.booleanValue()) {
                    this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor);
                } else {
                    this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor.getTreeNext());
                }
            }
            return super.addInternal(first, last, anchor, before);
        }
        return super.addInternal(first, last, anchor, before);
    }

    @NotNull
    public List<? extends PsiElement> getComponents() {
        return Arrays.asList(this.getTypeArgumentElements());
    }
}

