/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.toplevel.packaging;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrPackageDefinitionStub;

public class GrPackageDefinitionImpl
extends GrStubElementBase<GrPackageDefinitionStub>
implements GrPackageDefinition,
StubBasedPsiElement<GrPackageDefinitionStub> {
    public GrPackageDefinitionImpl(@NotNull ASTNode node) {
        super(node);
    }

    public GrPackageDefinitionImpl(@NotNull GrPackageDefinitionStub stub) {
        super(stub, GroovyStubElementTypes.PACKAGE_DEFINITION);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitPackageDefinition(this);
    }

    public String toString() {
        return "Package definition";
    }

    @Override
    public String getPackageName() {
        GrPackageDefinitionStub stub = (GrPackageDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getPackageName();
        }
        GrCodeReferenceElement ref2 = this.getPackageReference();
        return ref2 == null ? "" : ref2.getQualifiedReferenceName();
    }

    @Override
    public GrCodeReferenceElement getPackageReference() {
        return (GrCodeReferenceElement)this.findChildByType(GroovyElementTypes.REFERENCE_ELEMENT);
    }

    @Override
    @NotNull
    public GrModifierList getAnnotationList() {
        return (GrModifierList)this.getStubOrPsiChild(GroovyStubElementTypes.MODIFIER_LIST);
    }

    public PsiModifierList getModifierList() {
        return this.getAnnotationList();
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        PsiModifierList list = this.getModifierList();
        return list != null && list.hasExplicitModifier(name);
    }
}

