/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.lang.Language;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightModifierList;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightTypeElement;

public class GrLightParameter
extends LightVariableBuilder<GrLightParameter>
implements GrParameter {
    public static final GrLightParameter[] EMPTY_ARRAY = new GrLightParameter[0];
    private volatile boolean myOptional;
    private volatile GrModifierList myModifierList;
    private volatile GrExpression myInitializer;
    private final PsiElement myScope;
    private final GrTypeElement myTypeElement;
    private final PsiType myTypeGroovy;

    public GrLightParameter(@NlsSafe @NotNull String name, @Nullable PsiType type2, @NotNull PsiElement scope) {
        super(scope.getManager(), name, GrLightParameter.getTypeNotNull(type2, scope), (Language)GroovyLanguage.INSTANCE);
        this.myScope = scope;
        this.myModifierList = new GrLightModifierList(this);
        this.myTypeGroovy = type2;
        this.myTypeElement = type2 == null ? null : new GrLightTypeElement(type2, scope.getManager());
    }

    public GrLightParameter(@NotNull GrParameter parameter) {
        super(parameter.getManager(), parameter.getName(), GrLightParameter.getTypeNotNull(parameter.getType(), parameter), (Language)GroovyLanguage.INSTANCE);
        this.myScope = parameter;
        this.myTypeGroovy = parameter.getTypeGroovy();
        this.myTypeElement = this.myTypeGroovy == null ? null : new GrLightTypeElement(this.myTypeGroovy, parameter.getManager());
        this.myOptional = parameter.isOptional();
        GrLightModifierList modifierList = new GrLightModifierList(this);
        modifierList.copyModifiers((PsiModifierListOwner)parameter);
        this.myModifierList = modifierList;
    }

    public void setModifierList(GrModifierList modifierList) {
        this.myModifierList = modifierList;
    }

    @NotNull
    private static PsiType getTypeNotNull(PsiType type2, PsiElement scope) {
        return type2 != null ? type2 : TypesUtil.getJavaLangObject(scope);
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        return this.myScope;
    }

    public boolean isVarArgs() {
        return this.getType() instanceof PsiEllipsisType;
    }

    @Override
    public GrTypeElement getTypeElementGroovy() {
        return this.myTypeElement;
    }

    @Override
    public GrExpression getInitializerGroovy() {
        return this.myInitializer;
    }

    public PsiElement getContext() {
        return this.getDeclarationScope();
    }

    public PsiFile getContainingFile() {
        return this.getDeclarationScope().getContainingFile();
    }

    public GrLightParameter setOptional(boolean optional) {
        this.myOptional = optional;
        return this;
    }

    @Override
    public boolean isOptional() {
        return this.myOptional;
    }

    @Override
    @Nullable
    public PsiElement getEllipsisDots() {
        return null;
    }

    @Override
    public void setType(@Nullable PsiType type2) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        return null;
    }

    @Override
    public PsiType getTypeGroovy() {
        return this.myTypeGroovy;
    }

    @Override
    public PsiType getDeclaredType() {
        return this.myTypeGroovy;
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
    }

    @Override
    public void acceptChildren(@NotNull GroovyElementVisitor visitor2) {
    }

    public boolean isValid() {
        return this.getDeclarationScope().isValid();
    }

    @Override
    @NotNull
    public GrModifierList getModifierList() {
        return this.myModifierList;
    }

    @Override
    public void setInitializerGroovy(GrExpression initializer) {
        this.myInitializer = initializer;
    }

    public GrLightParameter setModifiers(String ... modifiers) {
        GrLightModifierList modifiersList = new GrLightModifierList(this.getContext());
        modifiersList.setModifiers(modifiers);
        this.myModifierList = modifiersList;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrLightParameter parameter = (GrLightParameter)o;
        return this.myOptional == parameter.myOptional && Objects.equals(this.myModifierList, parameter.myModifierList) && Objects.equals(this.myInitializer, parameter.myInitializer) && Objects.equals(this.myTypeGroovy, parameter.myTypeGroovy);
    }

    public int hashCode() {
        return Objects.hash(this.myOptional, this.myModifierList, this.myInitializer, this.myTypeGroovy);
    }
}

