/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrRenameableLightElement;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrVariableEnhancer;

public class ClosureSyntheticParameter
extends GrLightParameter
implements NavigationItem,
GrRenameableLightElement {
    private static final Function<ClosureSyntheticParameter, PsiType> TYPES_CALCULATOR = parameter -> {
        PsiType typeGroovy = GrVariableEnhancer.getEnhancedType(parameter);
        if (typeGroovy instanceof PsiIntersectionType) {
            return ((PsiIntersectionType)typeGroovy).getRepresentative();
        }
        return typeGroovy;
    };
    private final SmartPsiElementPointer<GrClosableBlock> myClosure;

    public ClosureSyntheticParameter(@NotNull GrClosableBlock closure, boolean isOptional) {
        super("it", (PsiType)TypesUtil.getJavaLangObject(closure), closure);
        this.setOptional(isOptional);
        this.myClosure = SmartPointerManager.createPointer((PsiElement)closure);
    }

    public PsiElement getParent() {
        return this.myClosure.getElement();
    }

    public PsiElement setName(@NotNull String newName) throws IncorrectOperationException {
        if (!newName.equals(this.getName())) {
            GrParameter parameter = GroovyPsiElementFactory.getInstance(this.getProject()).createParameter(newName, null, null);
            GrClosableBlock closure = (GrClosableBlock)this.myClosure.getElement();
            if (closure == null) {
                throw new IncorrectOperationException("Invalidated element pointer");
            }
            closure.addParameter(parameter);
        }
        return this;
    }

    @Override
    @Nullable
    public PsiType getTypeGroovy() {
        assert (this.isValid());
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPES_CALCULATOR);
    }

    @Override
    @Nullable
    public PsiType getDeclaredType() {
        return null;
    }

    public boolean isWritable() {
        return true;
    }

    @NotNull
    public SearchScope getUseScope() {
        GrClosableBlock closure = (GrClosableBlock)this.myClosure.getElement();
        if (closure == null) {
            throw new IncorrectOperationException("Pointer is invalidated");
        }
        return new LocalSearchScope((PsiElement)closure);
    }

    public boolean isStillValid() {
        return this.myClosure.getElement() != null;
    }

    public GrClosableBlock getClosure() {
        GrClosableBlock closure = (GrClosableBlock)this.myClosure.getElement();
        if (closure == null) {
            throw new IncorrectOperationException("Pointer is invalidated");
        }
        return closure;
    }

    @Override
    @NotNull
    public PsiElement getDeclarationScope() {
        GrClosableBlock smartClosure = (GrClosableBlock)this.myClosure.getElement();
        return smartClosure != null ? smartClosure : super.getDeclarationScope();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClosureSyntheticParameter)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClosureSyntheticParameter parameter = (ClosureSyntheticParameter)o;
        return Objects.equals(this.myClosure, parameter.myClosure);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myClosure);
    }
}

