/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.enumConstant;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumConstantInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrFieldImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFieldStub;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorReference;
import org.jetbrains.plugins.groovy.lang.resolve.references.GrEnumConstructorReference;

public class GrEnumConstantImpl
extends GrFieldImpl
implements GrEnumConstant {
    private final GroovyConstructorReference myReference = new GrEnumConstructorReference(this);

    public GrEnumConstantImpl(@NotNull ASTNode node) {
        super(node);
    }

    public GrEnumConstantImpl(GrFieldStub stub) {
        super(stub, (IStubElementType)GroovyStubElementTypes.ENUM_CONSTANT);
    }

    @Override
    public String toString() {
        return "Enumeration constant";
    }

    @Override
    @Nullable
    public GrModifierList getModifierList() {
        return (GrModifierList)this.getStubOrPsiChild(GroovyElementTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String property) {
        if (property.equals("static")) {
            return true;
        }
        if (property.equals("public")) {
            return true;
        }
        return property.equals("final");
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitEnumConstant(this);
    }

    @Override
    @Nullable
    public GrTypeElement getTypeElementGroovy() {
        return null;
    }

    @Override
    @NotNull
    public PsiType getType() {
        return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType(this.getContainingClass(), PsiSubstitutor.EMPTY);
    }

    @Override
    @Nullable
    public PsiType getDeclaredType() {
        return this.getType();
    }

    @Override
    @Nullable
    public PsiType getTypeGroovy() {
        return this.getType();
    }

    @Override
    public void setType(@Nullable PsiType type2) {
        throw new RuntimeException("Cannot set type for enum constant");
    }

    @Override
    @Nullable
    public GrExpression getInitializerGroovy() {
        return null;
    }

    @Override
    public boolean isProperty() {
        return false;
    }

    @Override
    public GroovyResolveResult[] multiResolveClass() {
        GroovyResolveResultImpl result2 = new GroovyResolveResultImpl((PsiElement)this.getContainingClass(), this, null, PsiSubstitutor.EMPTY, true, true);
        return new GroovyResolveResult[]{result2};
    }

    @Override
    @Nullable
    public GrArgumentList getArgumentList() {
        return (GrArgumentList)this.findChildByClass(GrArgumentList.class);
    }

    @Override
    public GrNamedArgument addNamedArgument(GrNamedArgument namedArgument) throws IncorrectOperationException {
        GrArgumentList list = this.getArgumentList();
        assert (list != null);
        if (list.getText().trim().isEmpty()) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
            GrArgumentList newList = factory.createArgumentList();
            list = (GrArgumentList)list.replace(newList);
        }
        return list.addNamedArgument(namedArgument);
    }

    @Override
    public GrNamedArgument @NotNull [] getNamedArguments() {
        GrArgumentList argumentList = this.getArgumentList();
        return argumentList == null ? GrNamedArgument.EMPTY_ARRAY : argumentList.getNamedArguments();
    }

    @Override
    public GrExpression @NotNull [] getExpressionArguments() {
        GrArgumentList argumentList = this.getArgumentList();
        return argumentList == null ? GrExpression.EMPTY_ARRAY : argumentList.getExpressionArguments();
    }

    @Override
    public GroovyResolveResult @NotNull [] getCallVariants(@Nullable GrExpression upToArgument) {
        return this.multiResolve(true);
    }

    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        return JavaResolveResult.EMPTY;
    }

    @Override
    @Nullable
    public GrEnumConstantInitializer getInitializingClass() {
        return (GrEnumConstantInitializer)this.getStubOrPsiChild(GroovyStubElementTypes.ENUM_CONSTANT_INITIALIZER);
    }

    @NotNull
    public PsiEnumConstantInitializer getOrCreateInitializingClass() {
        GrEnumConstantInitializer initializingClass = this.getInitializingClass();
        if (initializingClass != null) {
            return initializingClass;
        }
        GrEnumConstantInitializer initializer = GroovyPsiElementFactory.getInstance(this.getProject()).createEnumConstantFromText("foo{}").getInitializingClass();
        LOG.assertTrue(initializer != null);
        GrArgumentList argumentList = this.getArgumentList();
        if (argumentList != null) {
            return (PsiEnumConstantInitializer)this.addAfter(initializer, argumentList);
        }
        return (PsiEnumConstantInitializer)this.addAfter(initializer, this.getNameIdentifierGroovy());
    }

    public PsiReference getReference() {
        return this.myReference;
    }

    public PsiMethod resolveConstructor() {
        return this.resolveMethod();
    }

    @Override
    public GroovyResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        return this.myReference.multiResolve(incompleteCode);
    }

    @Override
    @NotNull
    public PsiClass getContainingClass() {
        PsiClass aClass = super.getContainingClass();
        assert (aClass != null);
        return aClass;
    }

    @Override
    @Nullable
    public Object computeConstantValue() {
        return this;
    }

    @Override
    @NotNull
    public GroovyConstructorReference getConstructorReference() {
        return this.myReference;
    }
}

