/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiListLikeElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrReferenceListStub;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrReferenceListImpl
extends GrStubElementBase<GrReferenceListStub>
implements StubBasedPsiElement<GrReferenceListStub>,
GrReferenceList,
PsiListLikeElement {
    private static final Logger LOG = Logger.getInstance(GrReferenceListImpl.class);
    private PsiClassType[] myCachedTypes;

    public GrReferenceListImpl(@NotNull ASTNode node) {
        super(node);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement psi = child.getPsi();
        if (psi instanceof GrCodeReferenceElement) {
            GrCodeReferenceElement[] refs = this.getReferenceElementsGroovy();
            if (refs.length == 1) {
                PsiElement keyword = this.getKeyword();
                LOG.assertTrue(keyword != null);
                keyword.delete();
            } else {
                PsiElement comma;
                boolean forward = refs[0] == psi;
                PsiElement psiElement = comma = forward ? PsiUtil.skipWhitespacesAndComments(psi.getNextSibling(), true, true) : PsiUtil.skipWhitespacesAndComments(psi.getPrevSibling(), false, true);
                if (comma != null && comma.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
                    comma.delete();
                }
            }
        }
        super.deleteChildInternal(child);
    }

    @Override
    @Nullable
    public PsiElement getKeyword() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild != null && firstChild.getNode().getElementType() == this.getKeywordType()) {
            return firstChild;
        }
        return null;
    }

    public GrReferenceListImpl(GrReferenceListStub stub, IStubElementType elementType) {
        super(stub, elementType);
    }

    @Override
    public GrCodeReferenceElement @NotNull [] getReferenceElementsGroovy() {
        GrReferenceListStub stub = (GrReferenceListStub)this.getStub();
        if (stub != null) {
            String[] baseClasses = stub.getBaseClasses();
            GrCodeReferenceElement[] result2 = new GrCodeReferenceElement[baseClasses.length];
            for (int i2 = 0; i2 < baseClasses.length; ++i2) {
                result2[i2] = GroovyPsiElementFactory.getInstance(this.getProject()).createCodeReference(baseClasses[i2], this);
            }
            return result2;
        }
        return (GrCodeReferenceElement[])this.findChildrenByClass(GrCodeReferenceElement.class);
    }

    public PsiClassType @NotNull [] getReferencedTypes() {
        if (this.myCachedTypes == null || !this.isValid()) {
            ArrayList<GrClassReferenceType> types = new ArrayList<GrClassReferenceType>();
            for (GrCodeReferenceElement ref2 : this.getReferenceElementsGroovy()) {
                types.add(new GrClassReferenceType(ref2));
            }
            this.myCachedTypes = types.toArray(PsiClassType.EMPTY_ARRAY);
        }
        return this.myCachedTypes;
    }

    public void subtreeChanged() {
        this.myCachedTypes = null;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element instanceof GrCodeReferenceElement || element instanceof PsiJavaCodeReferenceElement) {
            IElementType keywordType = this.getKeywordType();
            if (keywordType == null) {
                return super.add(element);
            }
            if (this.findChildByType(keywordType) == null) {
                this.getNode().getTreeParent().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", this.getNode());
                this.getNode().addLeaf(keywordType, (CharSequence)keywordType.toString(), null);
            } else if (this.findChildByClass(GrCodeReferenceElement.class) != null) {
                PsiElement lastChild = this.getLastChild();
                if (!(lastChild = PsiUtil.skipWhitespacesAndComments(lastChild, false)).getNode().getElementType().equals(GroovyTokenTypes.mCOMMA)) {
                    this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", null);
                }
            }
        }
        return super.add(element);
    }

    @Nullable
    protected abstract IElementType getKeywordType();

    @NotNull
    public List<? extends PsiElement> getComponents() {
        return Arrays.asList(this.getReferenceElementsGroovy());
    }
}

