/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyEmptyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class GrEnumTypeDefinitionImpl
extends GrTypeDefinitionImpl
implements GrEnumTypeDefinition {
    @NotNull
    private static final Key<Boolean> PREDEFINED_ENUM_METHOD = Key.create((String)"PREDEFINED_ENUM_METHOD");

    public GrEnumTypeDefinitionImpl(@NotNull ASTNode node) {
        super(node);
    }

    public GrEnumTypeDefinitionImpl(GrTypeDefinitionStub stub) {
        super(stub, (IStubElementType)GroovyStubElementTypes.ENUM_TYPE_DEFINITION);
    }

    public String toString() {
        return "Enumeration definition";
    }

    @Override
    public GrEnumDefinitionBody getBody() {
        return (GrEnumDefinitionBody)this.getStubOrPsiChild((IStubElementType)GroovyEmptyStubElementTypes.ENUM_BODY);
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public PsiClassType @NotNull [] getExtendsListTypes(boolean includeSynthetic) {
        return new PsiClassType[]{this.createEnumType()};
    }

    private PsiClassType createEnumType() {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        PsiClass enumClass = facade.findClass("java.lang.Enum", this.getResolveScope());
        PsiElementFactory factory = facade.getElementFactory();
        if (enumClass != null) {
            PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
            PsiTypeParameter[] typeParameters = enumClass.getTypeParameters();
            if (typeParameters.length == 1) {
                substitutor2 = substitutor2.put(typeParameters[0], (PsiType)factory.createType((PsiClass)this));
            }
            return factory.createType(enumClass, substitutor2);
        }
        return TypesUtil.createTypeByFQClassName("java.lang.Enum", this);
    }

    @ApiStatus.Internal
    public List<PsiMethod> getDefEnumMethods(@NotNull TransformationContext context) {
        PsiManagerEx manager = this.getManager();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.getProject());
        PsiClassType thisType = context.eraseClassType(factory.createType((PsiClass)this, PsiSubstitutor.EMPTY));
        List<PsiMethod> result2 = Arrays.asList(new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "values").setMethodReturnType((PsiType)new PsiArrayType((PsiType)thisType)).setContainingClass((PsiClass)this).addModifier("public").addModifier("static"), new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "next").setMethodReturnType((PsiType)thisType).setContainingClass((PsiClass)this).addModifier("public"), new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "previous").setMethodReturnType((PsiType)thisType).setContainingClass((PsiClass)this).addModifier("public"), new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "valueOf").setMethodReturnType((PsiType)thisType).setContainingClass((PsiClass)this).addParameter("name", "java.lang.String").addModifier("public").addModifier("static"));
        for (PsiMethod method : result2) {
            method.putUserData(PREDEFINED_ENUM_METHOD, (Object)true);
        }
        return result2;
    }

    public boolean isPredefinedEnumMethod(@NotNull PsiMethod method) {
        return method.getUserData(PREDEFINED_ENUM_METHOD) != null;
    }

    @Override
    public GrEnumConstant @NotNull [] getEnumConstants() {
        GrEnumDefinitionBody body = this.getBody();
        return body == null ? GrEnumConstant.EMPTY_ARRAY : body.getEnumConstants();
    }

    @Override
    public GrEnumConstantList getEnumConstantList() {
        GrEnumDefinitionBody enumDefinitionBody = this.getBody();
        return enumDefinitionBody == null ? null : enumDefinitionBody.getEnumConstantList();
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitEnumDefinition(this);
    }

    @Override
    public PsiElement add(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        GrEnumConstant[] constants;
        if (!(psiElement instanceof GrEnumConstant)) {
            return super.add(psiElement);
        }
        GrEnumDefinitionBody body = this.getBody();
        assert (body != null);
        GrEnumConstantList list = this.getEnumConstantList();
        if (list != null && (constants = list.getEnumConstants()).length > 0) {
            list.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", null);
            list.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", null);
            return list.add(psiElement);
        }
        PsiElement brace = body.getLBrace();
        return body.addAfter(psiElement, brace);
    }
}

