/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrMethodCallImpl;

public class GrMethodCallExpressionImpl
extends GrMethodCallImpl
implements GrMethodCallExpression,
GrCallExpression {
    public GrMethodCallExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    public String toString() {
        return "Method call";
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitMethodCallExpression(this);
    }

    @Override
    public GrExpression replaceClosureArgument(@NotNull GrClosableBlock closure, @NotNull GrExpression newExpr) throws IncorrectOperationException {
        if (newExpr instanceof GrClosableBlock) {
            return closure.replaceWithExpression(newExpr, true);
        }
        Object[] closureArguments = this.getClosureArguments();
        int i2 = ArrayUtil.find((Object[])closureArguments, (Object)closure);
        GrArgumentList argList = this.getArgumentList();
        if (argList.getText().isEmpty()) {
            argList = (GrArgumentList)argList.replace(GroovyPsiElementFactory.getInstance(this.getProject()).createArgumentList());
        }
        for (int j = 0; j < i2; ++j) {
            argList.add((PsiElement)closureArguments[j]);
            closureArguments[j].delete();
        }
        GrExpression result2 = (GrExpression)argList.add(newExpr);
        closure.delete();
        return result2;
    }

    @Override
    public boolean hasClosureArguments() {
        return this.findChildByClass(GrClosableBlock.class) != null;
    }

    @Override
    public GrClosableBlock @NotNull [] getClosureArguments() {
        return PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, GrClosableBlock.class).toArray(GrClosableBlock.EMPTY_ARRAY);
    }
}

