/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.impl.source.tree.java.PsiAnnotationImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.PairFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyEmptyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyStubElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrAnnotationStub;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImports;

public class GrAnnotationImpl
extends GrStubElementBase<GrAnnotationStub>
implements GrAnnotation,
StubBasedPsiElement<GrAnnotationStub> {
    private static final PairFunction<Project, String, PsiAnnotation> ANNOTATION_CREATOR = (project, text) -> GroovyPsiElementFactory.getInstance(project).createAnnotationFromText((String)text);

    public GrAnnotationImpl(@NotNull ASTNode node) {
        super(node);
    }

    public GrAnnotationImpl(GrAnnotationStub stub) {
        super(stub, GroovyStubElementTypes.ANNOTATION);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitAnnotation(this);
    }

    public String toString() {
        return "Annotation";
    }

    @Override
    @NotNull
    public GrAnnotationArgumentList getParameterList() {
        return (GrAnnotationArgumentList)this.getRequiredStubOrPsiChild((IStubElementType)GroovyEmptyStubElementTypes.ANNOTATION_ARGUMENT_LIST);
    }

    @Nullable
    @NonNls
    public String getQualifiedName() {
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        if (stub != null) {
            return stub.getPsiElement().getQualifiedName();
        }
        GrCodeReferenceElement nameRef = this.getClassReference();
        PsiElement resolved = nameRef.resolve();
        if (resolved instanceof PsiClass) {
            return ((PsiClass)resolved).getQualifiedName();
        }
        return null;
    }

    @Nullable
    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        GroovyResolveResult resolveResult2 = this.getClassReference().advancedResolve();
        PsiElement resolved = resolveResult2.getElement();
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        return new LightClassReference((PsiManager)this.getManager(), this.getClassReference().getText(), (PsiClass)resolved, resolveResult2.getSubstitutor());
    }

    @Nullable
    public PsiAnnotationMemberValue findAttributeValue(@Nullable String attributeName) {
        return PsiImplUtil.findAttributeValue((PsiAnnotation)this, (String)attributeName);
    }

    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue((PsiAnnotation)this, (String)attributeName);
    }

    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@Nullable @NonNls String attributeName, T value2) {
        return (T)PsiImplUtil.setDeclaredAttributeValue((PsiAnnotation)this, (String)attributeName, value2, ANNOTATION_CREATOR);
    }

    @Override
    @NotNull
    public GrCodeReferenceElement getClassReference() {
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        if (stub != null) {
            return stub.getPsiElement().getClassReference();
        }
        return (GrCodeReferenceElement)this.findNotNullChildByClass(GrCodeReferenceElement.class);
    }

    @Override
    @NotNull
    public String getShortName() {
        GrAnnotationStub stub = (GrAnnotationStub)this.getStub();
        if (stub != null) {
            return PsiAnnotationImpl.getAnnotationShortName((String)stub.getText());
        }
        String referenceName = this.getClassReference().getReferenceName();
        assert (referenceName != null);
        return referenceName;
    }

    @Nullable
    public PsiAnnotationOwner getOwner() {
        PsiElement parent2 = this.getParent();
        return parent2 instanceof PsiAnnotationOwner ? (PsiAnnotationOwner)parent2 : null;
    }

    public boolean hasQualifiedName(@NotNull String qualifiedName) {
        return this.mayHaveQualifiedName(qualifiedName) && qualifiedName.equals(this.getQualifiedName());
    }

    private boolean mayHaveQualifiedName(@NotNull String qualifiedName) {
        String shortName = this.getShortName();
        return shortName.equals(StringUtil.getShortName((String)qualifiedName)) || GroovyImports.getAliasedFullyQualifiedNames(this, shortName).contains(qualifiedName);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    PsiAnnotation.TargetType @NotNull [] getApplicableElementTypeFields(PsiElement owner) {
        if (owner instanceof PsiClass) {
            PsiClass aClass = (PsiClass)owner;
            if (aClass.isAnnotationType()) {
                return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.TYPE};
            }
            if (aClass instanceof GrTypeParameter) {
                return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_PARAMETER};
            }
            return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE};
        }
        if (owner instanceof GrMethod) {
            if (((PsiMethod)owner).isConstructor()) {
                return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.CONSTRUCTOR};
            }
            return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD};
        }
        if (owner instanceof GrVariableDeclaration) {
            GrVariable[] variables = ((GrVariableDeclaration)owner).getVariables();
            if (variables.length == 0) {
                return PsiAnnotation.TargetType.EMPTY_ARRAY;
            }
            if (variables[0] instanceof GrField || ResolveUtil.isScriptField(variables[0])) {
                return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.FIELD};
            }
            return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.LOCAL_VARIABLE};
        }
        if (owner instanceof GrParameter) {
            return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PARAMETER};
        }
        if (owner instanceof GrPackageDefinition) {
            return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PACKAGE};
        }
        if (owner instanceof GrTypeElement) {
            return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE};
        }
        if (owner instanceof GrCodeReferenceElement) {
            return new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE};
        }
        return PsiAnnotation.TargetType.EMPTY_ARRAY;
    }

    public static boolean isAnnotationApplicableTo(GrAnnotation annotation, PsiAnnotation.TargetType ... elementTypeFields) {
        return elementTypeFields.length == 0 || AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])elementTypeFields) != null;
    }
}

