/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrImmediateTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public abstract class GrTupleType
extends GrLiteralClassType {
    private final NotNullLazyValue<PsiType[]> myParameters = NotNullLazyValue.volatileLazy(() -> {
        List<PsiType> types = this.getComponentTypes();
        if (types.isEmpty()) {
            return PsiType.EMPTY_ARRAY;
        }
        PsiType leastUpperBound = this.getLeastUpperBound(types.toArray(PsiType.EMPTY_ARRAY));
        if (leastUpperBound == PsiType.NULL) {
            return EMPTY_ARRAY;
        }
        return new PsiType[]{leastUpperBound};
    });
    private final NotNullLazyValue<List<PsiType>> myComponents = NotNullLazyValue.volatileLazy(this::inferComponents);

    public GrTupleType(@NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade) {
        this(scope, facade, LanguageLevel.JDK_1_5);
    }

    public GrTupleType(@NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade, @NotNull LanguageLevel level) {
        super(level, scope, facade);
    }

    protected GrTupleType(@NotNull PsiElement context) {
        super(LanguageLevel.JDK_1_5, context);
    }

    @Override
    @NotNull
    protected String getJavaClassName() {
        return "java.util.List";
    }

    public @Nullable PsiType @NotNull [] getParameters() {
        return (PsiType[])this.myParameters.getValue();
    }

    @NotNull
    public String getInternalCanonicalText() {
        List<PsiType> types = this.getComponentTypes();
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i2 = 0; i2 < types.size(); ++i2) {
            if (i2 >= 2) {
                builder.append(",...");
                break;
            }
            if (i2 > 0) {
                builder.append(", ");
            }
            builder.append(GrTupleType.getInternalCanonicalText(types.get(i2)));
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrTupleType) {
            List<PsiType> componentTypes = this.getComponentTypes();
            List<PsiType> otherComponents = ((GrTupleType)((Object)obj)).getComponentTypes();
            return componentTypes.size() == otherComponents.size() && componentTypes.equals(otherComponents);
        }
        return super.equals(obj);
    }

    public boolean isAssignableFrom(@NotNull PsiType type2) {
        if (type2 instanceof GrTupleType) {
            List<PsiType> otherComponents = ((GrTupleType)type2).getComponentTypes();
            List<PsiType> componentTypes = this.getComponentTypes();
            for (int i2 = 0; i2 < Math.min(componentTypes.size(), otherComponents.size()); ++i2) {
                PsiType componentType = componentTypes.get(i2);
                PsiType otherComponent = otherComponents.get(i2);
                if (!(otherComponent == null ? componentType != null && !TypesUtil.isClassType(componentType, "java.lang.Object") : componentType != null && !componentType.isAssignableFrom(otherComponent))) continue;
                return false;
            }
            return true;
        }
        return super.isAssignableFrom(type2);
    }

    @NotNull
    public List<PsiType> getComponentTypes() {
        return (List)this.myComponents.getValue();
    }

    public final PsiType @NotNull [] getComponentTypesArray() {
        return this.getComponentTypes().toArray(PsiType.EMPTY_ARRAY);
    }

    @NotNull
    protected abstract List<PsiType> inferComponents();

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        return new GrImmediateTupleType(this.getComponentTypes(), this.myFacade, this.getResolveScope());
    }
}

