/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtilKt;

public final class GrAnnotationUtil {
    @Nullable
    public static String inferStringAttribute(@NotNull PsiAnnotation annotation, @NlsSafe @NotNull String attributeName) {
        PsiAnnotationMemberValue targetValue = annotation.findAttributeValue(attributeName);
        return GrAnnotationUtil.getString(targetValue);
    }

    @Nullable
    public static GrClosableBlock inferClosureAttribute(@NotNull PsiAnnotation annotation, @NlsSafe @NotNull String attributeName) {
        PsiAnnotationMemberValue targetValue = annotation.findAttributeValue(attributeName);
        if (targetValue instanceof GrClosableBlock) {
            return (GrClosableBlock)targetValue;
        }
        return null;
    }

    @Nullable
    public static String getString(@Nullable PsiAnnotationMemberValue targetValue) {
        Object value2;
        if (targetValue instanceof PsiLiteral && (value2 = ((PsiLiteral)targetValue).getValue()) instanceof String) {
            return (String)value2;
        }
        return null;
    }

    @Nullable
    public static Integer inferIntegerAttribute(@NotNull PsiAnnotation annotation, @NlsSafe @NotNull String attributeName) {
        Object value2;
        PsiAnnotationMemberValue targetValue = annotation.findAttributeValue(attributeName);
        if (targetValue instanceof PsiLiteral && (value2 = ((PsiLiteral)targetValue).getValue()) instanceof Integer) {
            return (Integer)value2;
        }
        return null;
    }

    @Nullable
    public static Boolean inferBooleanAttribute(@NotNull PsiAnnotation annotation, @NlsSafe @NotNull String attributeName) {
        Object value2;
        PsiAnnotationMemberValue targetValue = annotation.findAttributeValue(attributeName);
        if (targetValue instanceof PsiLiteral && (value2 = ((PsiLiteral)targetValue).getValue()) instanceof Boolean) {
            return (Boolean)value2;
        }
        return null;
    }

    public static boolean inferBooleanAttributeNotNull(@NotNull PsiAnnotation annotation, @NlsSafe @NotNull String attributeName) {
        Boolean result2 = GrAnnotationUtil.inferBooleanAttribute(annotation, attributeName);
        return result2 != null && result2 != false;
    }

    @Nullable
    public static PsiClass inferClassAttribute(@NotNull PsiAnnotation annotation, @NlsSafe @NotNull String attributeName) {
        PsiAnnotationMemberValue targetValue = annotation.findAttributeValue(attributeName);
        return GrAnnotationUtil.getPsiClass(targetValue);
    }

    @Nullable
    public static PsiClass getPsiClass(@Nullable PsiAnnotationMemberValue targetValue) {
        if (targetValue instanceof PsiClassObjectAccessExpression) {
            PsiType type2 = ((PsiClassObjectAccessExpression)targetValue).getOperand().getType();
            if (type2 instanceof PsiClassType) {
                return ((PsiClassType)type2).resolve();
            }
        } else if (targetValue instanceof GrReferenceExpression) {
            PsiElement resolved;
            GrExpression qualifier;
            if ("class".equals(((GrReferenceExpression)targetValue).getReferenceName()) && (qualifier = (GrExpression)((GrReferenceExpression)targetValue).getQualifier()) instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
                return (PsiClass)resolved;
            }
            PsiElement resolved2 = ((GrReferenceExpression)targetValue).resolve();
            if (resolved2 instanceof PsiClass) {
                return (PsiClass)resolved2;
            }
        }
        return null;
    }

    @Nullable
    public static PsiType extractClassTypeFromClassAttributeValue(PsiAnnotationMemberValue targetValue) {
        if (targetValue instanceof PsiClassObjectAccessExpression) {
            return ((PsiClassObjectAccessExpression)targetValue).getOperand().getType();
        }
        if (targetValue instanceof GrReferenceExpression) {
            PsiElement resolved;
            GrExpression qualifier;
            if ("class".equals(((GrReferenceExpression)targetValue).getReferenceName()) && (qualifier = (GrExpression)((GrReferenceExpression)targetValue).getQualifier()) instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
                return qualifier.getType();
            }
            PsiElement resolved2 = ((GrReferenceExpression)targetValue).resolve();
            if (resolved2 instanceof PsiClass) {
                return ((GrReferenceExpression)targetValue).getType();
            }
        }
        return null;
    }

    public static PsiElement getActualOwner(GrAnnotation annotation) {
        PsiAnnotationOwner owner = annotation.getOwner();
        if (owner instanceof PsiModifierList) {
            return ((PsiModifierList)owner).getParent();
        }
        return (PsiElement)owner;
    }

    public static List<PsiClass> getClassArrayValue(@NotNull PsiAnnotation annotation, @NlsSafe @NotNull String attributeName, boolean declared) {
        PsiAnnotationMemberValue value2 = declared ? annotation.findDeclaredAttributeValue(attributeName) : annotation.findAttributeValue(attributeName);
        return ContainerUtil.mapNotNull((Collection)AnnotationUtil.arrayAttributeValues((PsiAnnotationMemberValue)value2), GrAnnotationUtil::getPsiClass);
    }

    public static List<String> getStringArrayValue(@NotNull PsiAnnotation annotation, @NlsSafe @NotNull String attributeName, boolean declared) {
        PsiAnnotationMemberValue value2 = GrAnnotationUtil.findDetachedAttributeValue(annotation, attributeName, declared);
        if (value2 == null) {
            return Collections.emptyList();
        }
        return GrAnnotationUtilKt.getArrayValue(value2, AnnotationUtil::getStringAttributeValue);
    }

    @Nullable
    private static PsiAnnotationMemberValue findDetachedAttributeValue(@NotNull PsiAnnotation annotation, @NlsSafe @Nullable String attributeName, boolean declared) {
        PsiAnnotationMemberValue declaredValue = GrAnnotationUtilKt.findDeclaredDetachedValue(annotation, attributeName);
        if (declaredValue != null) {
            return declaredValue;
        }
        if (declared) {
            return null;
        }
        return annotation.findAttributeValue(attributeName);
    }
}

