/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;

public class AnnotationArgConverter {
    private static final Logger LOG = Logger.getInstance(AnnotationArgConverter.class);

    @Nullable
    public GrAnnotationMemberValue convert(PsiAnnotationMemberValue value2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("@A(");
        this.generateText(value2, buffer);
        buffer.append(")");
        String text = buffer.toString();
        try {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(value2.getProject());
            return factory.createAnnotationFromText(text).getParameterList().getAttributes()[0].getValue();
        }
        catch (IncorrectOperationException | ArrayIndexOutOfBoundsException e) {
            LOG.error("Text: \"" + text + "\"", e);
            return null;
        }
    }

    private void generateText(PsiAnnotationMemberValue value2, final @NlsSafe StringBuilder buffer) {
        value2.accept((PsiElementVisitor)new JavaElementVisitor(){

            public void visitAnnotation(@NotNull PsiAnnotation annotation) {
                buffer.append("@");
                PsiJavaCodeReferenceElement ref2 = annotation.getNameReferenceElement();
                if (ref2 == null) {
                    return;
                }
                PsiElement resolved = ref2.resolve();
                if (resolved instanceof PsiClass && ((PsiClass)resolved).getQualifiedName() != null) {
                    buffer.append(((PsiClass)resolved).getQualifiedName());
                } else {
                    buffer.append(ref2.getText());
                }
                PsiAnnotationParameterList parameterList = annotation.getParameterList();
                parameterList.accept((PsiElementVisitor)this);
            }

            public void visitAnnotationParameterList(@NotNull PsiAnnotationParameterList list) {
                PsiNameValuePair[] attributes = list.getAttributes();
                if (attributes.length > 0) {
                    buffer.append('(');
                    for (PsiNameValuePair attribute : attributes) {
                        attribute.accept((PsiElementVisitor)this);
                        buffer.append(',');
                    }
                    buffer.replace(buffer.length() - 1, buffer.length(), ")");
                }
            }

            public void visitNameValuePair(@NotNull PsiNameValuePair pair) {
                String name = pair.getName();
                PsiAnnotationMemberValue value2 = pair.getValue();
                if (name != null) {
                    buffer.append(name);
                    buffer.append('=');
                }
                if (value2 != null) {
                    value2.accept((PsiElementVisitor)this);
                }
            }

            public void visitExpression(@NotNull PsiExpression expression) {
                buffer.append(expression.getText());
            }

            public void visitAnnotationArrayInitializer(@NotNull PsiArrayInitializerMemberValue initializer) {
                PsiAnnotationMemberValue[] initializers = initializer.getInitializers();
                this.processInitializers(initializers);
            }

            public void visitNewExpression(@NotNull PsiNewExpression expression) {
                PsiArrayInitializerExpression arrayInitializer = expression.getArrayInitializer();
                if (arrayInitializer == null) {
                    super.visitNewExpression(expression);
                } else {
                    PsiType type2 = expression.getType();
                    if (type2 == null) {
                        type2 = PsiType.getJavaLangObject((PsiManager)expression.getManager(), (GlobalSearchScope)expression.getResolveScope()).createArrayType();
                    }
                    buffer.append('(');
                    arrayInitializer.accept((PsiElementVisitor)this);
                    buffer.append(" as ");
                    buffer.append(type2.getCanonicalText());
                    buffer.append(")");
                }
            }

            public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression arrayInitializer) {
                this.processInitializers((PsiAnnotationMemberValue[])arrayInitializer.getInitializers());
            }

            private void processInitializers(PsiAnnotationMemberValue[] initializers) {
                buffer.append('[');
                for (PsiAnnotationMemberValue initializer : initializers) {
                    initializer.accept((PsiElementVisitor)this);
                    buffer.append(',');
                }
                if (initializers.length > 0) {
                    buffer.delete(buffer.length() - 1, buffer.length());
                }
                buffer.append(']');
            }
        });
    }
}

