/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.DfaCacheConsistencyKt;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaState;

public class TypesSemilattice
implements Semilattice<TypeDfaState> {
    private final PsiManager myManager;

    public TypesSemilattice(@NotNull PsiManager manager) {
        this.myManager = manager;
    }

    @Override
    @NotNull
    public TypeDfaState join(@NotNull List<? extends TypeDfaState> ins) {
        if (ins.size() == 0) {
            return TypeDfaState.EMPTY_STATE;
        }
        if (ins.size() == 1) {
            return ins.get(0);
        }
        TypeDfaState result2 = ins.get(0);
        for (int i2 = 1; i2 < ins.size(); ++i2) {
            if (ins.get(i2) == TypeDfaState.EMPTY_STATE) {
                return TypeDfaState.EMPTY_STATE;
            }
            result2 = TypeDfaState.merge(result2, ins.get(i2), this.myManager);
        }
        return result2;
    }

    @Override
    public boolean eq(@NotNull TypeDfaState e1, @NotNull TypeDfaState e2) {
        return e1 == e2 || e1.contentsEqual(e2);
    }

    @Contract(pure=true)
    public static Int2ObjectMap<DFAType> mergeForCaching(@NotNull Int2ObjectMap<DFAType> cached, @Nullable TypeDfaState candidate) {
        if (candidate == null || candidate.getRawVarTypes().isEmpty()) {
            return cached;
        }
        SmartList newTypes = new SmartList();
        for (Int2ObjectMap.Entry candidateEntry : candidate.getRawVarTypes().int2ObjectEntrySet()) {
            int index = candidateEntry.getIntKey();
            if (candidate.isProhibited(index) || cached.containsKey(index) && TypesSemilattice.checkDfaStatesConsistency(cached, (Int2ObjectMap.Entry<DFAType>)candidateEntry)) continue;
            newTypes.add(candidateEntry);
        }
        if (newTypes.isEmpty()) {
            return cached;
        }
        Int2ObjectOpenHashMap newState = new Int2ObjectOpenHashMap(cached.size() + newTypes.size());
        newState.putAll(cached);
        for (Int2ObjectMap.Entry entry : newTypes) {
            newState.put(entry.getIntKey(), (Object)((DFAType)entry.getValue()));
        }
        return newState;
    }

    private static boolean checkDfaStatesConsistency(@NotNull Int2ObjectMap<DFAType> cached, @NotNull Int2ObjectMap.Entry<DFAType> incoming) {
        if (!ApplicationManager.getApplication().isUnitTestMode() || ApplicationManagerEx.isInStressTest() || DfaCacheConsistencyKt.mustSkipConsistencyCheck()) {
            return true;
        }
        DFAType cachedType = (DFAType)cached.get(incoming.getIntKey());
        if (cachedType != null && !Objects.equals(cachedType, incoming.getValue())) {
            throw new IllegalStateException("Attempt to cache different types: for descriptor " + incoming.getIntKey() + ", existing was " + cachedType + " and incoming is " + incoming.getValue());
        }
        return true;
    }
}

