/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.types;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ArgumentsInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GroovyControlFlow;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ResolvedVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAType;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.DFAFlowInfo;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.InferenceCache;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.InitialTypeProvider;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeAugmenter;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeDfaState;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;

class TypeDfaInstance
implements DfaInstance<TypeDfaState> {
    private final GroovyControlFlow myFlow;
    private final DFAFlowInfo myFlowInfo;
    private final InferenceCache myCache;
    private final PsiManager myManager;
    private final InitialTypeProvider myInitialTypeProvider;

    TypeDfaInstance(@NotNull GroovyControlFlow flow, @NotNull DFAFlowInfo flowInfo, @NotNull InferenceCache cache2, @NotNull PsiManager manager, @NotNull InitialTypeProvider typeProvider) {
        this.myFlow = flow;
        this.myManager = manager;
        this.myFlowInfo = flowInfo;
        this.myCache = cache2;
        this.myInitialTypeProvider = typeProvider;
    }

    @Override
    public TypeDfaState fun(@NotNull TypeDfaState state, @NotNull Instruction instruction) {
        TypeDfaState newState = instruction.num() == 0 ? this.handleStartInstruction() : (instruction instanceof ReadWriteVariableInstruction ? this.handleReadWriteVariable(state, (ReadWriteVariableInstruction)instruction) : (instruction instanceof MixinTypeInstruction ? this.handleMixin(state, (MixinTypeInstruction)instruction) : (instruction instanceof ArgumentsInstruction ? this.handleArguments(state, (ArgumentsInstruction)instruction) : (instruction instanceof NegatingGotoInstruction ? TypeDfaInstance.handleNegation(state, (NegatingGotoInstruction)instruction) : state))));
        this.myCache.publishDescriptor(newState, instruction);
        return newState;
    }

    private TypeDfaState handleStartInstruction() {
        TypeDfaState state = TypeDfaState.EMPTY_STATE;
        for (int descriptor : this.myFlowInfo.getInterestingDescriptors()) {
            PsiType initialType = this.myInitialTypeProvider.initialType(descriptor);
            if (initialType == null) continue;
            state = state.withNewType(descriptor, DFAType.create(initialType));
        }
        return state;
    }

    private static boolean hasNoChanges(@NotNull TypeDfaState baseDfaState, @NotNull Int2ObjectMap<DFAType> newDfaTypes) {
        Int2ObjectMap<DFAType> oldMap = baseDfaState.getRawVarTypes();
        for (Int2ObjectMap.Entry entry : newDfaTypes.int2ObjectEntrySet()) {
            if (oldMap.containsKey(entry.getIntKey()) && ((DFAType)oldMap.get(entry.getIntKey())).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private TypeDfaState handleMixin(@NotNull TypeDfaState state, @NotNull MixinTypeInstruction instruction) {
        int descriptor = instruction.getVariableDescriptor();
        if (descriptor == 0) {
            return state;
        }
        return this.updateVariableType(state, instruction, descriptor, () -> {
            ReadWriteVariableInstruction originalInstr = instruction.getInstructionToMixin(this.myFlow.getFlow());
            if (originalInstr != null) assert (!originalInstr.isWrite());
            return state.getNotNullDFAType(descriptor).withNewMixin(instruction.inferMixinType(), instruction.getConditionInstruction());
        });
    }

    private TypeDfaState handleReadWriteVariable(@NotNull TypeDfaState state, @NotNull ReadWriteVariableInstruction instruction) {
        PsiElement element = instruction.getElement();
        if (element == null) {
            return state;
        }
        int descriptor = instruction.getDescriptor();
        if (instruction.isWrite()) {
            return this.updateVariableType(state, instruction, descriptor, () -> {
                PsiType initializerType = TypeInferenceHelper.getInitializerType(element);
                VariableDescriptor actualDescriptor = this.myFlow.getVarIndices()[descriptor];
                if (initializerType == null && actualDescriptor instanceof ResolvedVariableDescriptor && TypeInferenceHelper.isSimpleEnoughForAugmenting(this.myFlow.getFlow())) {
                    GrVariable variable = ((ResolvedVariableDescriptor)actualDescriptor).getVariable();
                    PsiType augmentedType = TypeAugmenter.Companion.inferAugmentedType(variable);
                    return DFAType.create(augmentedType);
                }
                return DFAType.create(initializerType);
            });
        }
        return state;
    }

    private TypeDfaState handleArguments(TypeDfaState state, ArgumentsInstruction instruction) {
        TypeDfaState newState = state;
        for (Map.Entry<Integer, Collection<Argument>> entry : instruction.getArguments().entrySet()) {
            int descriptor = entry.getKey();
            Collection<Argument> arguments2 = entry.getValue();
            newState = this.handleArgument(newState, instruction, descriptor, arguments2);
        }
        return newState;
    }

    private TypeDfaState handleArgument(TypeDfaState state, ArgumentsInstruction instruction, int descriptorId, Collection<Argument> arguments2) {
        return this.updateVariableType(state, instruction, descriptorId, () -> {
            GroovyResolveResult[] results;
            DFAType result2 = state.getNotNullDFAType(descriptorId);
            for (GroovyResolveResult variant : results = instruction.getElement().multiResolve(false)) {
                ArgumentMapping<PsiCallParameter> mapping2;
                GroovyMethodCandidate candidate;
                if (!(variant instanceof GroovyMethodResult) || (candidate = ((GroovyMethodResult)variant).getCandidate()) == null || (mapping2 = candidate.getArgumentMapping()) == null) continue;
                for (Argument argument : arguments2) {
                    PsiType parameterType = mapping2.expectedType(argument);
                    if (parameterType == null) continue;
                    PsiType typeToMixin = variant.getSubstitutor().substitute(parameterType);
                    result2 = result2.withNewMixin(typeToMixin, null);
                }
            }
            return result2;
        });
    }

    private TypeDfaState updateVariableType(@NotNull TypeDfaState state, @NotNull Instruction instruction, int descriptorId, @NotNull Supplier<DFAType> computation) {
        if (descriptorId == 0) {
            return state;
        }
        if (!this.myFlowInfo.getInterestingInstructions().contains(instruction)) {
            return state.withRemovedBinding(descriptorId);
        }
        DFAType type2 = this.myCache.getCachedInferredType(descriptorId, instruction);
        if (type2 == null) {
            type2 = this.myFlowInfo.getAcyclicInstructions().contains(instruction) ? computation.get() : this.runWithoutCaching(state, computation);
        }
        return state.withNewType(descriptorId, type2);
    }

    private <T> T runWithoutCaching(@NotNull TypeDfaState state, Supplier<? extends T> computation) {
        Map<VariableDescriptor, DFAType> unwrappedVariables = this.getCurrentVariableTypes(state);
        return TypeInferenceHelper.doInference(unwrappedVariables, computation);
    }

    @NotNull
    private Map<VariableDescriptor, DFAType> getCurrentVariableTypes(@NotNull TypeDfaState state) {
        HashMap<VariableDescriptor, DFAType> unwrappedVariables = new HashMap<VariableDescriptor, DFAType>();
        for (Int2ObjectMap.Entry entry : state.getRawVarTypes().int2ObjectEntrySet()) {
            if (state.isProhibited(entry.getIntKey())) continue;
            unwrappedVariables.put(this.myFlow.getVarIndices()[entry.getIntKey()], (DFAType)entry.getValue());
        }
        return unwrappedVariables;
    }

    private static TypeDfaState handleNegation(@NotNull TypeDfaState state, @NotNull NegatingGotoInstruction negation) {
        TypeDfaState newState = state;
        for (Int2ObjectMap.Entry entry : state.getRawVarTypes().int2ObjectEntrySet()) {
            DFAType after;
            DFAType before = (DFAType)entry.getValue();
            if (before == (after = before.withNegated(negation))) continue;
            newState = newState.withNewType(entry.getIntKey(), after);
        }
        return newState;
    }
}

