/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.OrderUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GroovyControlFlow;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DFAEngine;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.FragmentVariableInfos;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsDfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.ReachingDefinitionsSemilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.VariableInfo;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ElementResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.GrReferenceResolveRunnerKt;

public final class ReachingDefinitionsCollector {
    private ReachingDefinitionsCollector() {
    }

    @NotNull
    public static FragmentVariableInfos obtainVariableFlowInformation(@NotNull GrStatement first, @NotNull GrStatement last, @NotNull GrControlFlowOwner flowOwner, @NotNull GroovyControlFlow flow) {
        VariableDescriptor descriptor;
        int descriptorId;
        Int2ObjectMap<int[]> dfaResult = ReachingDefinitionsCollector.inferDfaResult(flow.getFlow());
        LinkedHashSet<Integer> fragmentInstructions = ReachingDefinitionsCollector.getFragmentInstructions(first, last, flow.getFlow());
        int[] postorder = OrderUtil.reversedPostOrder(flow.getFlow());
        LinkedHashSet<Integer> reachableFromFragmentReads = ReachingDefinitionsCollector.getReachable(fragmentInstructions, flow.getFlow(), dfaResult, postorder);
        LinkedHashSet<Integer> fragmentReads = ReachingDefinitionsCollector.filterReads(fragmentInstructions, flow.getFlow());
        final LinkedHashMap<String, VariableInfo> imap = new LinkedHashMap<String, VariableInfo>();
        final LinkedHashMap<String, VariableInfo> omap = new LinkedHashMap<String, VariableInfo>();
        PsiManager manager = first.getManager();
        for (Integer ref2 : fragmentReads) {
            ReadWriteVariableInstruction rwInstruction = (ReadWriteVariableInstruction)flow.getFlow()[ref2];
            int[] defs = (int[])dfaResult.get(ref2.intValue());
            assert (defs != null);
            descriptorId = rwInstruction.getDescriptor();
            descriptor = flow.getVarIndices()[descriptorId];
            if (ReachingDefinitionsCollector.allDefsInFragment(defs, fragmentInstructions) && !ReachingDefinitionsCollector.isLocallyDeclaredOutOf(rwInstruction.getElement(), descriptor, flowOwner)) continue;
            ReachingDefinitionsCollector.addVariable(descriptor.getName(), imap, manager, ReachingDefinitionsCollector.getType(rwInstruction.getElement()));
        }
        Set<Integer> outerBound = ReachingDefinitionsCollector.getFragmentOuterBound(fragmentInstructions, flow.getFlow());
        for (Integer ref3 : reachableFromFragmentReads) {
            ReadWriteVariableInstruction rwInstruction = (ReadWriteVariableInstruction)flow.getFlow()[ref3];
            descriptorId = rwInstruction.getDescriptor();
            descriptor = flow.getVarIndices()[descriptorId];
            int[] defs = (int[])dfaResult.get(ref3.intValue());
            assert (defs != null);
            if (!ReachingDefinitionsCollector.anyDefInFragment(defs, fragmentInstructions)) continue;
            for (int insnNum : outerBound) {
                ReachingDefinitionsCollector.addVariable(descriptor.getName(), omap, manager, ReachingDefinitionsCollector.getVariableTypeAt(flowOwner, flow.getFlow()[insnNum], descriptorId, descriptor));
            }
            if (ReachingDefinitionsCollector.allProperDefsInFragment(defs, ref3, fragmentInstructions, postorder)) continue;
            PsiType inputType = ReachingDefinitionsCollector.getType(rwInstruction.getElement());
            ReachingDefinitionsCollector.addVariable(descriptor.getName(), imap, manager, inputType);
        }
        ReachingDefinitionsCollector.addClosureUsages(imap, omap, first, last, flowOwner);
        return new FragmentVariableInfos(){

            @Override
            public VariableInfo[] getInputVariableNames() {
                return imap.values().toArray(VariableInfo.EMPTY_ARRAY);
            }

            @Override
            public VariableInfo[] getOutputVariableNames() {
                return omap.values().toArray(VariableInfo.EMPTY_ARRAY);
            }
        };
    }

    private static PsiType getVariableTypeAt(GrControlFlowOwner flowOwner, Instruction instruction, int descriptorId, VariableDescriptor descriptor) {
        GrVariable variable;
        PsiElement context = instruction.getElement();
        PsiType outputType = TypeInferenceHelper.getInferredType(descriptorId, instruction, flowOwner);
        if (outputType == null && (variable = ReachingDefinitionsCollector.resolveToLocalVariable(context, descriptor.getName())) != null) {
            outputType = variable.getDeclaredType();
        }
        return outputType;
    }

    @Nullable
    private static GrVariable resolveToLocalVariable(@Nullable PsiElement element, @NotNull String name) {
        if (element == null) {
            return null;
        }
        ElementResolveResult<GrVariable> result2 = GrReferenceResolveRunnerKt.resolveToLocalVariable(element, name);
        return result2 != null ? result2.getElement() : null;
    }

    private static boolean isLocallyDeclaredOutOf(@Nullable PsiElement element, @NotNull VariableDescriptor descriptor, @NotNull GrControlFlowOwner flowOwner) {
        GrVariable variable = ReachingDefinitionsCollector.resolveToLocalVariable(element, descriptor.getName());
        if (variable == null) {
            return false;
        }
        return !PsiImplUtilKt.isDeclaredIn(variable, flowOwner);
    }

    @NotNull
    private static Int2ObjectMap<int[]> inferDfaResult(Instruction @NotNull [] flow) {
        ReachingDefinitionsDfaInstance dfaInstance = new ReachingDefinitionsDfaInstance();
        ReachingDefinitionsSemilattice lattice = new ReachingDefinitionsSemilattice();
        DFAEngine<DefinitionMap> engine = new DFAEngine<DefinitionMap>(flow, dfaInstance, lattice);
        return ReachingDefinitionsCollector.postprocess(engine.performForceDFA(), flow);
    }

    private static void addClosureUsages(final Map<String, VariableInfo> imap, final Map<String, VariableInfo> omap, final GrStatement first, final GrStatement last, GrControlFlowOwner flowOwner) {
        flowOwner.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitClosure(@NotNull GrClosableBlock closure) {
                this.addUsagesInClosure(imap, omap, closure, first, last);
                super.visitClosure(closure);
            }

            private void addUsagesInClosure(final Map<String, VariableInfo> imap2, final Map<String, VariableInfo> omap2, final GrClosableBlock closure, final GrStatement first2, final GrStatement last2) {
                closure.accept(new GroovyRecursiveElementVisitor(){

                    @Override
                    public void visitReferenceExpression(@NotNull GrReferenceExpression refExpr) {
                        if (refExpr.isQualified()) {
                            return;
                        }
                        String name = refExpr.getReferenceName();
                        if (name == null) {
                            return;
                        }
                        GrVariable variable = ReachingDefinitionsCollector.resolveToLocalVariable(refExpr, name);
                        if (variable == null) {
                            return;
                        }
                        if (PsiImplUtilKt.isDeclaredIn(variable, closure)) {
                            return;
                        }
                        if (!(variable instanceof GrField)) {
                            if (!ReachingDefinitionsCollector.isInFragment(first2, last2, variable)) {
                                if (ReachingDefinitionsCollector.isInFragment(first2, last2, (PsiElement)closure)) {
                                    ReachingDefinitionsCollector.addVariable(name, imap2, variable.getManager(), variable.getType());
                                }
                            } else if (!ReachingDefinitionsCollector.isInFragment(first2, last2, (PsiElement)closure)) {
                                ReachingDefinitionsCollector.addVariable(name, omap2, variable.getManager(), variable.getType());
                            }
                        }
                    }
                });
            }
        });
    }

    private static void addVariable(String name, Map<String, VariableInfo> map2, PsiManager manager, PsiType type2) {
        VariableInfoImpl info = (VariableInfoImpl)map2.get(name);
        if (info == null) {
            info = new VariableInfoImpl(name, manager);
            map2.put(name, info);
        }
        info.addSubtype(type2);
    }

    private static LinkedHashSet<Integer> filterReads(LinkedHashSet<Integer> instructions, Instruction[] flow) {
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>();
        for (Integer i2 : instructions) {
            Instruction instruction = flow[i2];
            if (!ReachingDefinitionsCollector.isReadInsn(instruction)) continue;
            result2.add(i2);
        }
        return result2;
    }

    private static boolean allDefsInFragment(int[] defs, LinkedHashSet<Integer> fragmentInstructions) {
        for (int def : defs) {
            if (fragmentInstructions.contains(def)) continue;
            return false;
        }
        return true;
    }

    private static boolean allProperDefsInFragment(int[] defs, int ref2, LinkedHashSet<Integer> fragmentInstructions, int[] postorder) {
        for (int def : defs) {
            if (fragmentInstructions.contains(def) || postorder[def] >= postorder[ref2]) continue;
            return false;
        }
        return true;
    }

    private static boolean anyDefInFragment(int[] defs, LinkedHashSet<Integer> fragmentInstructions) {
        for (int def : defs) {
            if (!fragmentInstructions.contains(def)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiType getType(PsiElement element) {
        if (element instanceof GrVariable) {
            return ((GrVariable)element).getTypeGroovy();
        }
        if (element instanceof GrReferenceExpression) {
            return ((GrReferenceExpression)element).getType();
        }
        return null;
    }

    private static LinkedHashSet<Integer> getFragmentInstructions(GrStatement first, GrStatement last, Instruction[] flow) {
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>();
        for (Instruction instruction : flow) {
            if (!ReachingDefinitionsCollector.isInFragment(instruction, first, last)) continue;
            result2.add(instruction.num());
        }
        return result2;
    }

    private static boolean isInFragment(Instruction instruction, GrStatement first, GrStatement last) {
        PsiElement element = instruction.getElement();
        if (element == null) {
            return false;
        }
        return ReachingDefinitionsCollector.isInFragment(first, last, element);
    }

    private static boolean isInFragment(GrStatement first, GrStatement last, PsiElement element) {
        PsiElement parent2 = first.getParent();
        if (!PsiTreeUtil.isAncestor((PsiElement)parent2, (PsiElement)element, (boolean)true)) {
            return false;
        }
        PsiElement run = element;
        while (run.getParent() != parent2) {
            run = run.getParent();
        }
        return ReachingDefinitionsCollector.isBetween(first, last, run);
    }

    private static boolean isBetween(PsiElement first, PsiElement last, PsiElement run) {
        while (first != null && first != run) {
            first = first.getNextSibling();
        }
        if (first == null) {
            return false;
        }
        while (last != null && last != run) {
            last = last.getPrevSibling();
        }
        return last != null;
    }

    private static LinkedHashSet<Integer> getReachable(LinkedHashSet<Integer> fragmentInsns, Instruction[] flow, @NotNull Int2ObjectMap<int[]> dfaResult, int[] postorder) {
        LinkedHashSet<Integer> result2 = new LinkedHashSet<Integer>();
        block0: for (Instruction insn : flow) {
            int ref2;
            int[] definitions;
            if (!ReachingDefinitionsCollector.isReadInsn(insn) || (definitions = (int[])dfaResult.get(ref2 = insn.num())) == null) continue;
            for (int def : definitions) {
                if (!fragmentInsns.contains(def) || fragmentInsns.contains(ref2) && (postorder[ref2] >= postorder[def] || !ReachingDefinitionsCollector.checkPathIsOutsideOfFragment(def, ref2, flow, fragmentInsns))) continue;
                result2.add(ref2);
                continue block0;
            }
        }
        return result2;
    }

    private static Set<Integer> getFragmentOuterBound(@NotNull LinkedHashSet<Integer> fragmentInstructions, Instruction @NotNull [] flow) {
        HashSet<Integer> result2 = new HashSet<Integer>();
        for (Integer num : fragmentInstructions) {
            for (Instruction successor : flow[num].allSuccessors()) {
                if (fragmentInstructions.contains(successor.num())) continue;
                result2.add(num);
            }
        }
        return result2;
    }

    private static boolean checkPathIsOutsideOfFragment(int def, int ref2, Instruction[] flow, LinkedHashSet<Integer> fragmentInsns) {
        Boolean path = ReachingDefinitionsCollector.findPath(flow[def], ref2, fragmentInsns, false, new HashMap<Instruction, Boolean>());
        assert (path != null) : "def=" + def + ", ref=" + ref2;
        return path;
    }

    @Nullable
    private static Boolean findPath(Instruction cur, int destination, LinkedHashSet<Integer> fragmentInsns, boolean wasOutside, HashMap<Instruction, Boolean> visited) {
        wasOutside = wasOutside || !fragmentInsns.contains(cur.num());
        visited.put(cur, null);
        Iterable<Instruction> instructions = cur.allSuccessors();
        boolean pathExists = false;
        for (Instruction i2 : instructions) {
            Boolean result2;
            if (i2.num() == destination) {
                return wasOutside;
            }
            if (visited.containsKey(i2)) {
                result2 = visited.get(i2);
            } else {
                result2 = ReachingDefinitionsCollector.findPath(i2, destination, fragmentInsns, wasOutside, visited);
                visited.put(i2, result2);
            }
            if (result2 == null) continue;
            if (result2.booleanValue()) {
                visited.put(cur, true);
                return true;
            }
            pathExists = true;
        }
        if (pathExists) {
            visited.put(cur, false);
            return false;
        }
        visited.put(cur, null);
        return null;
    }

    private static boolean isReadInsn(Instruction insn) {
        return insn instanceof ReadWriteVariableInstruction && !((ReadWriteVariableInstruction)insn).isWrite();
    }

    @NonNls
    private static String dumpDfaResult(ArrayList<Int2ObjectMap<IntSet>> dfaResult, ReachingDefinitionsDfaInstance dfa) {
        @NonNls StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < dfaResult.size(); ++i2) {
            Int2ObjectMap<IntSet> map2 = dfaResult.get(i2);
            buffer.append("At ").append(i2).append(":\n");
            for (IntSet v : map2.values()) {
                buffer.append(i2).append(" -> ");
                v.forEach(i1 -> buffer.append(i1).append(" "));
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    @NotNull
    private static Int2ObjectMap<int[]> postprocess(@NotNull List<DefinitionMap> dfaResult, Instruction @NotNull [] flow) {
        Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap();
        for (int i2 = 0; i2 < flow.length; ++i2) {
            int varIndex;
            ReadWriteVariableInstruction rwInsn;
            Instruction insn = flow[i2];
            if (!(insn instanceof ReadWriteVariableInstruction) || (rwInsn = (ReadWriteVariableInstruction)insn).isWrite()) continue;
            DefinitionMap definitionMap = dfaResult.get(i2);
            definitionMap = definitionMap == null ? DefinitionMap.NEUTRAL : definitionMap;
            IntSet defs = definitionMap.getDefinitions(varIndex = rwInsn.getDescriptor());
            if (defs == null) {
                defs = IntSet.of();
            }
            result2.put(i2, (Object)defs.toIntArray());
        }
        return result2;
    }

    private static class VariableInfoImpl
    implements VariableInfo {
        @NotNull
        private final String myName;
        private final PsiManager myManager;
        @Nullable
        private PsiType myType;

        VariableInfoImpl(@NotNull String name, PsiManager manager) {
            this.myName = name;
            this.myManager = manager;
        }

        @Override
        @NotNull
        public String getName() {
            return this.myName;
        }

        @Override
        @Nullable
        public PsiType getType() {
            if (this.myType instanceof PsiIntersectionType) {
                return ((PsiIntersectionType)this.myType).getConjuncts()[0];
            }
            return this.myType;
        }

        void addSubtype(PsiType t) {
            if (t != null) {
                if (this.myType == null) {
                    this.myType = t;
                } else if (!this.myType.isAssignableFrom(t)) {
                    this.myType = t.isAssignableFrom(this.myType) ? t : TypesUtil.getLeastUpperBound(this.myType, t, this.myManager);
                }
            }
        }
    }
}

