/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs;

import com.intellij.util.SmartList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;

public final class DefinitionMap {
    public static final DefinitionMap NEUTRAL = new DefinitionMap((Int2ObjectMap<IntSet>)new Int2ObjectOpenHashMap());
    @NotNull
    private final Int2ObjectMap<IntSet> myMap;

    private DefinitionMap(@NotNull Int2ObjectMap<IntSet> map2) {
        this.myMap = map2;
    }

    @Contract(pure=true)
    @NotNull
    public DefinitionMap withRegisteredDef(int varIndex, @NotNull Instruction instruction) {
        if (varIndex == 0) {
            return this;
        }
        Int2ObjectOpenHashMap newMap = new Int2ObjectOpenHashMap(this.myMap);
        IntArraySet defs = new IntArraySet(1);
        newMap.put(varIndex, (Object)defs);
        defs.add(instruction.num());
        return new DefinitionMap((Int2ObjectMap<IntSet>)newMap);
    }

    @Contract(pure=true)
    @NotNull
    public DefinitionMap withMerged(DefinitionMap other) {
        int key;
        if (other == this || other == NEUTRAL) {
            return this;
        }
        if (this == NEUTRAL) {
            return other;
        }
        Int2ObjectOpenHashMap newMap = new Int2ObjectOpenHashMap(this.myMap);
        SmartList toRemove = new SmartList();
        Object object = this.myMap.keySet().iterator();
        while (object.hasNext()) {
            key = (Integer)object.next();
            if (other.myMap.containsKey(key)) continue;
            toRemove.add(key);
        }
        object = toRemove.iterator();
        while (object.hasNext()) {
            key = (Integer)object.next();
            newMap.remove(key);
        }
        for (Int2ObjectMap.Entry entry : other.myMap.int2ObjectEntrySet()) {
            int varIndex = entry.getIntKey();
            IntSet otherVarDefs = (IntSet)entry.getValue();
            IntSet myDefs = (IntSet)newMap.get(varIndex);
            if (myDefs == null) continue;
            IntArraySet newDefs = new IntArraySet(myDefs);
            newDefs.addAll((IntCollection)otherVarDefs);
            newMap.put(varIndex, (Object)newDefs);
        }
        return new DefinitionMap((Int2ObjectMap<IntSet>)newMap);
    }

    @Nullable
    public IntSet getDefinitions(int varIndex) {
        return (IntSet)this.myMap.get(varIndex);
    }

    public void forEachValue(Consumer<IntSet> procedure) {
        this.myMap.values().forEach(procedure);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefinitionMap map2 = (DefinitionMap)o;
        return Objects.equals(this.myMap, map2.myMap);
    }

    public int hashCode() {
        return Objects.hash(this.myMap);
    }

    public String toString() {
        return this.myMap.toString();
    }
}

