/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.OrderUtil;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.WorkCounter;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.WorkList;

public final class DFAEngine<E> {
    private final Instruction[] myFlow;
    private final DfaInstance<E> myDfa;
    private final Semilattice<E> mySemilattice;
    private WorkCounter myCounter = null;

    public DFAEngine(Instruction @NotNull [] flow, @NotNull DfaInstance<E> dfa, @NotNull Semilattice<E> semilattice) {
        this.myFlow = flow;
        this.myDfa = dfa;
        this.mySemilattice = semilattice;
    }

    public @NotNull List<@Nullable E> performForceDFA() {
        List<E> result2 = this.performDFA(false);
        assert (result2 != null);
        return result2;
    }

    @Nullable
    public @Nullable List<@Nullable E> performDFAWithTimeout() {
        return this.performDFA(true);
    }

    @Nullable
    private @Nullable List<@Nullable E> performDFA(boolean timeout) {
        int n = this.myFlow.length;
        List<Optional<Optional<E>>> info = this.getEmptyInfo(n);
        MyCallEnvironment env = new MyCallEnvironment(n);
        WorkList workList = new WorkList(n, this.getFlowOrder());
        while (!workList.isEmpty()) {
            ProgressManager.checkCanceled();
            if (timeout && this.checkCounter()) {
                return null;
            }
            int num = workList.next();
            Instruction curr = this.myFlow[num];
            Optional<E> oldE = info.get(num);
            List<E> ins = this.getPrevInfos(curr, info, env);
            E jointE = this.mySemilattice.join(ins);
            E newE = this.myDfa.fun(jointE, curr);
            if (!oldE.isEmpty() && this.mySemilattice.eq(newE, oldE.get())) continue;
            info.set(num, Optional.of(newE));
            for (Instruction next : this.getNext(curr, env)) {
                workList.offer(next.num());
            }
        }
        return ContainerUtil.map(info, e -> e.orElse(null));
    }

    @NotNull
    private List<Optional<E>> getEmptyInfo(int n) {
        Object[] optionals = new Optional[n];
        Arrays.fill(optionals, Optional.empty());
        return Arrays.asList(optionals);
    }

    private int @NotNull [] getFlowOrder() {
        if (this.myDfa.isForward()) {
            return OrderUtil.reversedPostOrder(this.myFlow, this.myDfa.isReachable());
        }
        return OrderUtil.postOrder(this.myFlow, this.myDfa.isReachable());
    }

    @NotNull
    private List<E> getPrevInfos(@NotNull Instruction instruction, @NotNull List<Optional<E>> info, @NotNull CallEnvironment env) {
        SmartList prevInfos = new SmartList();
        for (Instruction i2 : this.getPrevious(instruction, env)) {
            Optional<E> prevInfo = info.get(i2.num());
            prevInfo.ifPresent(arg_0 -> DFAEngine.lambda$getPrevInfos$1((List)prevInfos, arg_0));
        }
        return prevInfos;
    }

    @NotNull
    private Iterable<Instruction> getPrevious(@NotNull Instruction instruction, @NotNull CallEnvironment env) {
        return this.myDfa.isForward() ? instruction.predecessors(env) : instruction.successors(env);
    }

    @NotNull
    private Iterable<Instruction> getNext(@NotNull Instruction instruction, @NotNull CallEnvironment env) {
        return this.myDfa.isForward() ? instruction.successors(env) : instruction.predecessors(env);
    }

    private boolean checkCounter() {
        if (this.myCounter == null) {
            this.myCounter = new WorkCounter();
            return false;
        }
        return this.myCounter.isTimeOver();
    }

    private static /* synthetic */ void lambda$getPrevInfos$1(List prevInfos, Object e) {
        prevInfos.add(e);
    }

    private static final class MyCallEnvironment
    implements CallEnvironment {
        ArrayList<Deque<CallInstruction>> myEnv;

        private MyCallEnvironment(int instructionNum) {
            this.myEnv = new ArrayList(instructionNum);
            for (int i2 = 0; i2 < instructionNum; ++i2) {
                this.myEnv.add(new ArrayDeque());
            }
        }

        @Override
        @NotNull
        public Deque<CallInstruction> callStack(@NotNull Instruction instruction) {
            return this.myEnv.get(instruction.num());
        }

        @Override
        public void update(@NotNull Deque<CallInstruction> callStack, @NotNull Instruction instruction) {
            this.myEnv.set(instruction.num(), callStack);
        }
    }
}

