/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocParameterReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTagValueToken;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GroovyDocPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterListOwner;
import org.jetbrains.plugins.groovy.lang.resolve.ElementResolveResult;

public class GrDocParameterReferenceImpl
extends GroovyDocPsiElementImpl
implements GrDocParameterReference {
    public GrDocParameterReferenceImpl(@NotNull ASTNode node) {
        super(node);
    }

    public String toString() {
        return "GrDocParameterReference";
    }

    public PsiReference getReference() {
        return this;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ASTNode node;
        String name = this.getName();
        if (name == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        ArrayList<ElementResolveResult<GrParameter>> candidates = new ArrayList<ElementResolveResult<GrParameter>>();
        GrDocCommentOwner owner = GrDocCommentUtil.findDocOwner(this);
        if (owner instanceof GrMethod && !name.startsWith("<")) {
            GrParameter[] parameters2;
            GrMethod method = (GrMethod)owner;
            for (GrParameter parameter : parameters2 = method.getParameters()) {
                if (!name.equals(parameter.getName())) continue;
                candidates.add(new ElementResolveResult<GrParameter>(parameter));
            }
            return candidates.toArray(ResolveResult.EMPTY_ARRAY);
        }
        String typeParameterName = name.length() >= 3 && name.startsWith("<") && name.endsWith(">") ? name.substring(1, name.length() - 1) : name;
        PsiElement firstChild = this.getFirstChild();
        if (owner instanceof GrTypeParameterListOwner && firstChild != null && (node = firstChild.getNode()) != null) {
            PsiTypeParameter[] typeParameters;
            for (PsiTypeParameter typeParameter : typeParameters = ((PsiTypeParameterListOwner)owner).getTypeParameters()) {
                if (!typeParameterName.equals(typeParameter.getName())) continue;
                candidates.add(new ElementResolveResult<PsiTypeParameter>(typeParameter));
            }
        }
        return candidates.toArray(ResolveResult.EMPTY_ARRAY);
    }

    @NotNull
    public PsiElement getElement() {
        return this;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    public String getName() {
        return this.getText();
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        if (results.length != 1) {
            return null;
        }
        return results[0].getElement();
    }

    @NotNull
    public String getCanonicalText() {
        return this.getName();
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        ASTNode node = this.getNode();
        ASTNode newNameNode = GroovyPsiElementFactory.getInstance(this.getProject()).createDocMemberReferenceNameFromText(newElementName).getNode();
        assert (newNameNode != null);
        node.getTreeParent().replaceChild(node, newNameNode);
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (this.isReferenceTo(element)) {
            return this;
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (!(element instanceof GrParameter) && !(element instanceof GrTypeParameter)) {
            return false;
        }
        return this.getManager().areElementsEquivalent(element, this.resolve());
    }

    public Object @NotNull [] getVariants() {
        ASTNode node;
        GrDocCommentOwner owner = GrDocCommentUtil.findDocOwner(this);
        PsiElement firstChild = this.getFirstChild();
        if (owner instanceof GrTypeParameterListOwner && firstChild != null && (node = firstChild.getNode()) != null && node.getText().startsWith("<")) {
            return ((PsiTypeParameterListOwner)owner).getTypeParameters();
        }
        if (owner instanceof PsiMethod) {
            return ((PsiMethod)owner).getParameterList().getParameters();
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public GrDocTagValueToken getReferenceNameElement() {
        GrDocTagValueToken token = (GrDocTagValueToken)this.findChildByClass(GrDocTagValueToken.class);
        assert (token != null);
        return token;
    }
}

