/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParams;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodReference;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocMemberReferenceImpl;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;

public class GrDocMethodReferenceImpl
extends GrDocMemberReferenceImpl
implements GrDocMethodReference {
    public GrDocMethodReferenceImpl(@NotNull ASTNode node) {
        super(node);
    }

    public String toString() {
        return "GrDocMethodReference";
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        visitor2.visitDocMethodReference(this);
    }

    @Override
    @NotNull
    public GrDocMethodParams getParameterList() {
        GrDocMethodParams child = (GrDocMethodParams)this.findChildByClass(GrDocMethodParams.class);
        assert (child != null);
        return child;
    }

    @Override
    public PsiElement bindToText(Project project, String text) {
        GrDocComment comment = GroovyPsiElementFactory.getInstance(project).createDocCommentFromText(text);
        PsiElement tag = PsiTreeUtil.getChildOfType((PsiElement)comment, GrDocTag.class);
        PsiElement ref2 = PsiTreeUtil.getChildOfType((PsiElement)tag, GrDocMethodReference.class);
        assert (ref2 != null) : text;
        return this.replace(ref2);
    }

    @Override
    public PsiElement resolve() {
        GrCodeReferenceElement referenceElement;
        String name = this.getReferenceName();
        GrDocReferenceElement holder = this.getReferenceHolder();
        Object resolved = holder != null ? ((referenceElement = holder.getReferenceElement()) != null ? referenceElement.resolve() : null) : PsiUtil.getContextClass(this);
        if (resolved instanceof PsiClass) {
            PsiType[] parameterTypes = this.getParameterList().getParameterTypes();
            PsiClassType thisType = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType(resolved, PsiSubstitutor.EMPTY);
            MethodResolverProcessor processor = new MethodResolverProcessor(name, this, false, (PsiType)thisType, parameterTypes, PsiType.EMPTY_ARRAY);
            resolved.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)resolved, (PsiElement)this);
            if (processor.hasApplicableCandidates()) {
                return processor.getCandidates()[0].getElement();
            }
            MethodResolverProcessor constructorProcessor = new MethodResolverProcessor(name, this, true, (PsiType)thisType, parameterTypes, PsiType.EMPTY_ARRAY);
            resolved.processDeclarations((PsiScopeProcessor)constructorProcessor, ResolveState.initial(), (PsiElement)resolved, (PsiElement)this);
            if (constructorProcessor.hasApplicableCandidates()) {
                return constructorProcessor.getCandidates()[0].getElement();
            }
        }
        return null;
    }

    @Override
    protected ResolveResult[] multiResolveImpl() {
        GrCodeReferenceElement referenceElement;
        String name = this.getReferenceName();
        GrDocReferenceElement holder = this.getReferenceHolder();
        Object resolved = holder != null ? ((referenceElement = holder.getReferenceElement()) != null ? referenceElement.resolve() : null) : PsiUtil.getContextClass(this);
        if (resolved instanceof PsiClass) {
            PsiType[] parameterTypes = this.getParameterList().getParameterTypes();
            PsiClassType thisType = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType(resolved, PsiSubstitutor.EMPTY);
            MethodResolverProcessor processor = new MethodResolverProcessor(name, this, false, (PsiType)thisType, parameterTypes, PsiType.EMPTY_ARRAY);
            MethodResolverProcessor constructorProcessor = new MethodResolverProcessor(name, this, true, (PsiType)thisType, parameterTypes, PsiType.EMPTY_ARRAY);
            resolved.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)resolved, (PsiElement)this);
            resolved.processDeclarations((PsiScopeProcessor)constructorProcessor, ResolveState.initial(), (PsiElement)resolved, (PsiElement)this);
            return (ResolveResult[])ArrayUtil.mergeArrays((Object[])processor.getCandidates(), (Object[])constructorProcessor.getCandidates());
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element instanceof PsiNamedElement && Objects.equals(((PsiNamedElement)element).getName(), this.getReferenceName())) {
            return this.getManager().areElementsEquivalent(element, this.resolve());
        }
        return false;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PsiElement resolved = this.resolve();
        if (resolved instanceof PsiMethod) {
            String newPropertyName;
            PsiMethod method = (PsiMethod)resolved;
            String oldName = this.getReferenceName();
            if (!method.getName().equals(oldName) && PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)method) && (newPropertyName = PropertyUtilBase.getPropertyName((String)newElementName)) != null) {
                return super.handleElementRename(newPropertyName);
            }
        }
        return super.handleElementRename(newElementName);
    }
}

