/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.documentation;

import com.intellij.codeInsight.javadoc.JavaDocHighlightingManager;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;

public class GroovyDocHighlightingManager
implements JavaDocHighlightingManager {
    @NotNull
    private static final GroovyDocHighlightingManager INSTANCE = new GroovyDocHighlightingManager();

    @NotNull
    public static GroovyDocHighlightingManager getInstance() {
        return INSTANCE;
    }

    @NotNull
    private static TextAttributes resolveAttributes(@NotNull TextAttributesKey attributesKey) {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey);
    }

    @NotNull
    public TextAttributes getClassDeclarationAttributes(@NotNull PsiClass aClass) {
        if (aClass.isInterface()) {
            return this.getInterfaceNameAttributes();
        }
        if (aClass.isEnum()) {
            return this.getEnumNameAttributes();
        }
        if (aClass instanceof PsiAnonymousClass) {
            return this.getAnonymousClassNameAttributes();
        }
        if (aClass.hasModifierProperty("abstract")) {
            return this.getAbstractClassNameAttributes();
        }
        return this.getClassNameAttributes();
    }

    @NotNull
    public TextAttributes getMethodDeclarationAttributes(@NotNull PsiMethod method) {
        return method.isConstructor() ? this.getConstructorDeclarationAttributes() : this.getMethodDeclarationAttributes();
    }

    @NotNull
    public TextAttributes getFieldDeclarationAttributes(@NotNull PsiField field) {
        boolean isStatic = field.hasModifierProperty("static");
        return isStatic ? this.getStaticFieldAttributes() : this.getInstanceFieldAttributes();
    }

    @NotNull
    public TextAttributes getInterfaceNameAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.INTERFACE_NAME);
    }

    @NotNull
    public TextAttributes getEnumNameAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.ENUM_NAME);
    }

    @NotNull
    public TextAttributes getAnonymousClassNameAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.ANONYMOUS_CLASS_NAME);
    }

    @NotNull
    public TextAttributes getAbstractClassNameAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.ABSTRACT_CLASS_NAME);
    }

    @NotNull
    public TextAttributes getClassNameAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.CLASS_REFERENCE);
    }

    @NotNull
    public TextAttributes getKeywordAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.KEYWORD);
    }

    @NotNull
    public TextAttributes getCommaAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(JavaHighlightingColors.COMMA);
    }

    @NotNull
    public TextAttributes getParameterAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.PARAMETER);
    }

    @NotNull
    public TextAttributes getTypeParameterNameAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.TYPE_PARAMETER);
    }

    @NotNull
    public TextAttributes getStaticFieldAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.STATIC_FIELD);
    }

    @NotNull
    public TextAttributes getInstanceFieldAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.INSTANCE_FIELD);
    }

    @NotNull
    public TextAttributes getOperationSignAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.OPERATION_SIGN);
    }

    @NotNull
    public TextAttributes getLocalVariableAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.LOCAL_VARIABLE);
    }

    @NotNull
    public TextAttributes getConstructorDeclarationAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.CONSTRUCTOR_DECLARATION);
    }

    @NotNull
    public TextAttributes getMethodDeclarationAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.METHOD_DECLARATION);
    }

    @NotNull
    public TextAttributes getParenthesesAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.PARENTHESES);
    }

    @NotNull
    public TextAttributes getDotAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(JavaHighlightingColors.DOT);
    }

    @NotNull
    public TextAttributes getBracketsAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.BRACKETS);
    }

    @NotNull
    public TextAttributes getMethodCallAttributes() {
        return GroovyDocHighlightingManager.resolveAttributes(GroovySyntaxHighlighter.METHOD_CALL);
    }
}

