/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.documentation;

import com.intellij.codeInsight.javadoc.DocumentationDelegateProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrLightDocumentationDelegateProvider
extends DocumentationDelegateProvider {
    @Nullable
    public PsiDocCommentOwner computeDocumentationDelegate(@NotNull PsiMember member) {
        if (!(member instanceof PsiMethod) || member.isPhysical()) {
            return null;
        }
        String data = (String)member.getUserData(ResolveUtil.DOCUMENTATION_DELEGATE_FQN);
        if (StringUtil.isEmptyOrSpaces((String)data)) {
            return null;
        }
        PsiClass clazz = JavaPsiFacade.getInstance((Project)member.getProject()).findClass(data, member.getResolveScope());
        return clazz == null ? null : clazz.findMethodBySignature((PsiMethod)member, false);
    }
}

