/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.impl;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.api.GroovyCompletionConsumer;

public class AccumulatingGroovyCompletionConsumer
implements GroovyCompletionConsumer {
    private final CompletionResultSet myResultSet;
    private final Set<LookupElement> myAccumulator;

    public AccumulatingGroovyCompletionConsumer(CompletionResultSet set) {
        this(set, ConcurrentCollectionFactory.createConcurrentIdentitySet());
    }

    private AccumulatingGroovyCompletionConsumer(CompletionResultSet set, Set<LookupElement> accumulator) {
        this.myResultSet = set;
        this.myAccumulator = accumulator;
    }

    @Override
    public void consume(@NotNull LookupElement element) {
        this.myAccumulator.add(element);
    }

    @Override
    public void fastElementsProcessed(CompletionParameters parameters2) {
        HashSet<LookupElement> newSet = new HashSet<LookupElement>(this.myAccumulator);
        this.myAccumulator.clear();
        this.myResultSet.addAllElements(newSet);
    }

    @Override
    public void interrupt() {
        this.close();
        this.myResultSet.stopHere();
    }

    @Override
    public void close() {
        this.myResultSet.addAllElements(this.myAccumulator);
    }

    @Override
    @NotNull
    public GroovyCompletionConsumer transform(@NotNull Function<? super CompletionResultSet, ? extends CompletionResultSet> transformer) {
        return new AccumulatingGroovyCompletionConsumer(transformer.apply((CompletionResultSet)this.getCompletionResultSet()), this.myAccumulator);
    }

    @Override
    @NotNull
    public CompletionResultSet getCompletionResultSet() {
        return this.myResultSet;
    }
}

