/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ProcessingContext;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentProvider;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentUtilKt;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;
import org.jetbrains.plugins.groovy.lang.completion.handlers.NamedArgumentInsertHandler;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

final class MapArgumentCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static final ElementPattern<PsiElement> IN_ARGUMENT_LIST_OF_CALL = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(GrReferenceExpression.class).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(GrArgumentList.class), PlatformPatterns.psiElement().withParent(GrArgumentList.class), PlatformPatterns.psiElement(GrListOrMap.class)})));
    public static final ElementPattern<PsiElement> IN_LABEL = PlatformPatterns.psiElement((IElementType)GroovyTokenTypes.mIDENT).withParent(GrArgumentLabel.class);

    private MapArgumentCompletionProvider() {
    }

    public static void register(CompletionContributor contributor) {
        MapArgumentCompletionProvider instance = new MapArgumentCompletionProvider();
        contributor.extend(CompletionType.BASIC, IN_ARGUMENT_LIST_OF_CALL, (CompletionProvider)instance);
        contributor.extend(CompletionType.BASIC, IN_LABEL, (CompletionProvider)instance);
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiElement mapOrArgumentList = MapArgumentCompletionProvider.findMapOrArgumentList(parameters2);
        if (mapOrArgumentList == null) {
            return;
        }
        if (MapArgumentCompletionProvider.isMapKeyCompletion(parameters2)) {
            result2.stopHere();
        }
        HashMap<String, NamedArgumentDescriptor> map2 = new HashMap<String, NamedArgumentDescriptor>(MapArgumentCompletionProvider.calculateNamedArguments(mapOrArgumentList));
        for (GrNamedArgument argument : MapArgumentCompletionProvider.getSiblingNamedArguments(mapOrArgumentList)) {
            map2.remove(argument.getLabelName());
        }
        for (Map.Entry entry : map2.entrySet()) {
            LookupElementBuilder lookup = LookupElementBuilder.create(entry.getValue(), (String)((String)entry.getKey())).withInsertHandler((InsertHandler)NamedArgumentInsertHandler.INSTANCE).withTailText(":");
            if (((NamedArgumentDescriptor)entry.getValue()).getPriority() == NamedArgumentDescriptor.Priority.UNLIKELY) {
                Color fg;
                TextAttributes defaultAttributes = GroovySyntaxHighlighter.MAP_KEY.getDefaultAttributes();
                if (defaultAttributes != null && (fg = defaultAttributes.getForegroundColor()) != null) {
                    lookup = lookup.withItemTextForeground(fg);
                }
            } else {
                lookup = lookup.withIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Property));
            }
            LookupElement customized = ((NamedArgumentDescriptor)entry.getValue()).customizeLookupElement(lookup);
            result2.addElement((LookupElement)(customized == null ? lookup : customized));
        }
    }

    public static boolean isMapKeyCompletion(CompletionParameters parameters2) {
        PsiElement mapOrArgumentList = MapArgumentCompletionProvider.findMapOrArgumentList(parameters2);
        return mapOrArgumentList instanceof GrListOrMap && ((GrListOrMap)mapOrArgumentList).getNamedArguments().length > 0;
    }

    @Nullable
    private static PsiElement findMapOrArgumentList(CompletionParameters parameters2) {
        PsiElement parent2 = parameters2.getPosition().getParent();
        if (parent2 instanceof GrReferenceExpression) {
            if (((GrReferenceExpression)parent2).getQualifier() != null) {
                return null;
            }
            return parent2.getParent();
        }
        if (parent2 == null || parent2.getParent() == null) {
            return null;
        }
        return parent2.getParent().getParent();
    }

    @NotNull
    private static Map<String, NamedArgumentDescriptor> findOtherNamedArgumentsInFile(PsiElement mapOrArgumentList) {
        final HashMap<String, NamedArgumentDescriptor> map2 = new HashMap<String, NamedArgumentDescriptor>();
        mapOrArgumentList.getContainingFile().accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                String name;
                if (element instanceof GrArgumentLabel && GroovyNamesUtil.isIdentifier(name = ((GrArgumentLabel)element).getName())) {
                    map2.put(name, NamedArgumentDescriptor.SIMPLE_UNLIKELY);
                }
                super.visitElement(element);
            }
        });
        return map2;
    }

    private static GrNamedArgument[] getSiblingNamedArguments(PsiElement mapOrArgumentList) {
        PsiElement argumentList;
        if (mapOrArgumentList instanceof GrListOrMap) {
            return ((GrListOrMap)mapOrArgumentList).getNamedArguments();
        }
        PsiElement psiElement = argumentList = mapOrArgumentList instanceof GrArgumentList ? mapOrArgumentList : mapOrArgumentList.getParent();
        if (argumentList instanceof GrArgumentList && argumentList.getParent() instanceof GrCall) {
            return PsiUtil.getFirstMapNamedArguments((GrCall)argumentList.getParent());
        }
        return GrNamedArgument.EMPTY_ARRAY;
    }

    @NotNull
    private static Map<String, NamedArgumentDescriptor> calculateNamedArguments(@NotNull PsiElement mapOrArgumentList) {
        Map<String, NamedArgumentDescriptor> map2 = MapArgumentCompletionProvider.calcNamedArgumentsForCall(mapOrArgumentList);
        if ((map2 == null || map2.isEmpty()) && mapOrArgumentList instanceof GrListOrMap) {
            map2 = NamedArgumentUtilKt.getDescriptors((GrListOrMap)mapOrArgumentList);
        }
        if (map2 == null || map2.isEmpty()) {
            map2 = MapArgumentCompletionProvider.findOtherNamedArgumentsInFile(mapOrArgumentList);
        }
        return map2;
    }

    @Nullable
    private static Map<String, NamedArgumentDescriptor> calcNamedArgumentsForCall(@NotNull PsiElement mapOrArgumentList) {
        PsiElement argumentList;
        PsiElement psiElement = argumentList = mapOrArgumentList instanceof GrArgumentList ? mapOrArgumentList : mapOrArgumentList.getParent();
        if (argumentList instanceof GrArgumentList) {
            if (mapOrArgumentList instanceof GrListOrMap && (((GrArgumentList)argumentList).getNamedArguments().length > 0 || ((GrArgumentList)argumentList).getExpressionArgumentIndex((GrListOrMap)mapOrArgumentList) > 0)) {
                return Collections.emptyMap();
            }
            if (argumentList.getParent() instanceof GrCall) {
                return GroovyNamedArgumentProvider.getNamedArgumentsFromAllProviders((GrCall)argumentList.getParent(), null, true);
            }
        }
        return Collections.emptyMap();
    }
}

