/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;

public class GrDummyIdentifierProvider {
    public static final String DUMMY_IDENTIFIER_DECAPITALIZED = StringUtil.decapitalize((String)"IntellijIdeaRulezzz ");
    private final CompletionInitializationContext myContext;

    public GrDummyIdentifierProvider(@NotNull CompletionInitializationContext context) {
        this.myContext = context;
    }

    @Nullable
    public String getIdentifier() {
        if (this.myContext.getCompletionType() == CompletionType.BASIC && this.myContext.getFile() instanceof GroovyFile) {
            PsiElement position = this.myContext.getFile().findElementAt(this.myContext.getStartOffset());
            if (position != null && position.getParent() instanceof GrVariable && position == ((GrVariable)position.getParent()).getNameIdentifierGroovy() || position != null && position.getParent() instanceof GrAnnotationNameValuePair && position == ((GrAnnotationNameValuePair)position.getParent()).getNameIdentifierGroovy()) {
                return CompletionUtil.DUMMY_IDENTIFIER_TRIMMED;
            }
            if (GrDummyIdentifierProvider.isIdentifierBeforeLParenth(position)) {
                return this.setCorrectCase() + ";";
            }
            if (GroovyCompletionUtil.isInPossibleClosureParameter(position)) {
                return this.setCorrectCase() + "->";
            }
            if (GrDummyIdentifierProvider.isIdentifierBeforeAssign(position)) {
                return CompletionUtil.DUMMY_IDENTIFIER_TRIMMED;
            }
            return this.setCorrectCase();
        }
        return null;
    }

    @NotNull
    private String setCorrectCase() {
        PsiElement element = this.myContext.getFile().findElementAt(this.myContext.getStartOffset());
        if (element == null) {
            return DUMMY_IDENTIFIER_DECAPITALIZED;
        }
        String text = element.getText();
        if (text.isEmpty()) {
            return DUMMY_IDENTIFIER_DECAPITALIZED;
        }
        return Character.isUpperCase(text.charAt(0)) ? "IntellijIdeaRulezzz " : DUMMY_IDENTIFIER_DECAPITALIZED;
    }

    private static boolean isIdentifierBeforeAssign(@Nullable PsiElement position) {
        ASTNode node = GrDummyIdentifierProvider.findNodeAfterIdent(position);
        return node != null && node.getElementType() == GroovyTokenTypes.mASSIGN;
    }

    private static boolean isIdentifierBeforeLParenth(@Nullable PsiElement position) {
        ASTNode node = GrDummyIdentifierProvider.findNodeAfterIdent(position);
        return node != null && node.getElementType() == GroovyTokenTypes.mLPAREN;
    }

    @Nullable
    private static ASTNode findNodeAfterIdent(@Nullable PsiElement position) {
        if (position == null) {
            return null;
        }
        ASTNode node = position.getNode();
        if (node.getElementType() == GroovyTokenTypes.mIDENT) {
            node = TreeUtil.nextLeaf((ASTNode)node);
        }
        node = TreeUtil.skipWhitespaceAndComments((ASTNode)node, (boolean)true);
        return node;
    }
}

