/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.jarFinder;

import com.intellij.jarFinder.FindJarFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;

public class GroovyFindJarFix
extends FindJarFix<GrReferenceElement> {
    public GroovyFindJarFix(GrReferenceElement ref2) {
        super((PsiElement)ref2);
    }

    protected Collection<String> getFqns(@NotNull GrReferenceElement ref2) {
        GrImportStatement[] importList;
        GrImportStatement importStatement = (GrImportStatement)PsiTreeUtil.getParentOfType((PsiElement)ref2.getElement(), GrImportStatement.class);
        if (importStatement != null) {
            String fqn = importStatement.getImportFqn();
            return fqn == null ? Collections.emptyList() : Collections.singleton(fqn);
        }
        if (ref2.getQualifier() != null) {
            return Collections.emptyList();
        }
        String className = ref2.getReferenceName();
        if (className == null) {
            return Collections.emptyList();
        }
        PsiFile file = ref2.getContainingFile().getOriginalFile();
        if (!(file instanceof GroovyFile)) {
            return Collections.emptyList();
        }
        for (GrImportStatement imp : importList = ((GroovyFile)file).getImportStatements()) {
            if (!className.equals(imp.getImportedName())) continue;
            String fqn = imp.getImportFqn();
            return fqn == null ? Collections.emptyList() : Collections.singleton(fqn);
        }
        return Collections.emptyList();
    }
}

