/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.style.inference.DefaultInferenceContext;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessUtilKt;
import org.jetbrains.plugins.groovy.intentions.style.inference.SignatureInferenceOptions;
import org.jetbrains.plugins.groovy.intentions.style.inference.driver.InferenceDriverUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/groovy/intentions/style/InferMethodParametersTypesIntention;", "Lorg/jetbrains/plugins/groovy/intentions/base/Intention;", "()V", "collectParameterSubstitutor", "Lcom/intellij/psi/PsiSubstitutor;", "virtualMethod", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "getElementPredicate", "Lorg/jetbrains/plugins/groovy/intentions/base/PsiElementPredicate;", "getFamilyName", "", "getText", "isStopElement", "", "element", "Lcom/intellij/psi/PsiElement;", "processIntention", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "substituteMethodSignature", "sourceMethod", "sinkMethod", "intellij.groovy"})
public final class InferMethodParametersTypesIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, @Nullable Editor editor) {
        Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod");
        GrMethod method = (GrMethod)element;
        SignatureInferenceOptions options2 = new SignatureInferenceOptions(false, DefaultInferenceContext.INSTANCE);
        GrMethod virtualMethod = InferenceProcessKt.runInferenceProcess(method, options2);
        this.substituteMethodSignature(virtualMethod, method);
    }

    /*
     * WARNING - void declaration
     */
    private final void substituteMethodSignature(GrMethod sourceMethod, GrMethod sinkMethod) {
        block15: {
            Object object;
            block17: {
                block16: {
                    PsiType psiType;
                    int n;
                    if (!sinkMethod.isConstructor() && !sinkMethod.getModifierList().hasModifierProperty("def")) {
                        sinkMethod.getModifierList().setModifierProperty("def", true);
                    }
                    if (sourceMethod.hasTypeParameters()) {
                        if (sinkMethod.hasTypeParameters()) {
                            PsiTypeParameterList psiTypeParameterList = sinkMethod.getTypeParameterList();
                            Intrinsics.checkNotNull((Object)psiTypeParameterList);
                            PsiTypeParameterList psiTypeParameterList2 = sourceMethod.getTypeParameterList();
                            Intrinsics.checkNotNull((Object)psiTypeParameterList2);
                            psiTypeParameterList.replace((PsiElement)psiTypeParameterList2);
                        } else if (sinkMethod.isConstructor()) {
                            PsiSubstitutor parameterSubstitutor = this.collectParameterSubstitutor(sourceMethod);
                            Pair $this$forEach$iv = sourceMethod.getParameters();
                            boolean $i$f$forEach = false;
                            int n2 = ((Pair)$this$forEach$iv).length;
                            for (n = 0; n < n2; ++n) {
                                Pair element$iv;
                                Pair it = element$iv = $this$forEach$iv[n];
                                boolean bl = false;
                                it.setType(InferenceProcessUtilKt.recursiveSubstitute$default(parameterSubstitutor, it.getType(), 0, 2, null));
                            }
                        } else {
                            PsiTypeParameterList psiTypeParameterList = sourceMethod.getTypeParameterList();
                            Intrinsics.checkNotNull((Object)psiTypeParameterList);
                            sinkMethod.addAfter((PsiElement)psiTypeParameterList, sinkMethod.getFirstChild());
                        }
                    }
                    for (Pair $this$forEach$iv : ArraysKt.zip((Object[])sinkMethod.getParameters(), (Object[])sourceMethod.getParameters())) {
                        PsiReference psiReference;
                        void $this$mapTo$iv$iv;
                        GrParameter actual = (GrParameter)$this$forEach$iv.component1();
                        GrParameter inferred = (GrParameter)$this$forEach$iv.component2();
                        actual.setType(inferred.getType());
                        actual.getModifierList().setModifierProperty("def", false);
                        if (actual.isVarArgs()) {
                            PsiElement psiElement = actual.getEllipsisDots();
                            Intrinsics.checkNotNull((Object)psiElement);
                            psiElement.delete();
                        }
                        PsiAnnotation[] $this$map$iv = actual.getAnnotations();
                        boolean $i$f$map = false;
                        PsiAnnotation[] bl = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                        boolean $i$f$mapTo = false;
                        for (void item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            psiReference = item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(it.getText());
                        }
                        List currentAnnotations = (List)destination$iv$iv;
                        PsiAnnotation[] $this$forEach$iv2 = inferred.getAnnotations();
                        boolean $i$f$forEach = false;
                        int n3 = $this$forEach$iv2.length;
                        for (int j = 0; j < n3; ++j) {
                            PsiAnnotation element$iv;
                            PsiAnnotation it = element$iv = $this$forEach$iv2[j];
                            boolean bl3 = false;
                            if (currentAnnotations.contains(it.getText())) continue;
                            GrModifierList grModifierList = actual.getModifierList();
                            String string = it.getText().substring(1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                            PsiAnnotation anno = grModifierList.addAnnotation(string);
                            Intrinsics.checkNotNull((Object)anno, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation");
                            PsiElement psiElement = ((GrAnnotation)anno).getOriginalElement();
                            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement");
                            GrReferenceAdjuster.shortenAllReferencesIn((GroovyPsiElement)psiElement);
                            PsiAnnotationMemberValue psiAnnotationMemberValue = anno.findAttributeValue("value");
                            psiReference = psiAnnotationMemberValue != null ? psiAnnotationMemberValue.getReference() : null;
                            GrQualifiedReference grQualifiedReference = psiReference instanceof GrQualifiedReference ? (GrQualifiedReference)psiReference : null;
                            if (grQualifiedReference == null) continue;
                            GrReferenceAdjuster.shortenReference(grQualifiedReference);
                        }
                    }
                    PsiTypeParameter[] $this$forEach$iv = sinkMethod.getTypeParameters();
                    boolean $i$f$forEach = false;
                    n = $this$forEach$iv.length;
                    for (int j = 0; j < n; ++j) {
                        PsiTypeParameter element$iv;
                        PsiTypeParameter it = element$iv = $this$forEach$iv[j];
                        boolean bl = false;
                        GrReferenceAdjuster.shortenAllReferencesIn((GroovyPsiElement)it.getOriginalElement());
                    }
                    if (sinkMethod.isConstructor() || sinkMethod.getReturnTypeElement() != null) break block15;
                    object = sinkMethod.getInferredReturnType();
                    if (object == null) break block16;
                    PsiType it = psiType = object;
                    boolean bl = false;
                    object = !Intrinsics.areEqual((Object)it, (Object)PsiType.NULL) ? psiType : null;
                    if (object != null) break block17;
                }
                object = (PsiType)InferenceDriverUtilKt.getJavaLangObject(sinkMethod);
            }
            PsiType returnType2 = object;
            GrReferenceAdjuster.shortenAllReferencesIn(sinkMethod.setReturnType(returnType2));
        }
        sinkMethod.getModifierList().setModifierProperty("def", false);
    }

    /*
     * WARNING - void declaration
     */
    private final PsiSubstitutor collectParameterSubstitutor(GrMethod virtualMethod) {
        void $this$mapTo$iv$iv;
        PsiTypeParameter[] $this$map$iv = virtualMethod.getTypeParameters();
        boolean $i$f$map = false;
        PsiTypeParameter[] psiTypeParameterArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var11_10 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiClassType psiClassType = (PsiClassType)ArraysKt.firstOrNull((Object[])it.getExtendsListTypes());
            if (psiClassType == null) {
                psiClassType = InferenceDriverUtilKt.getJavaLangObject(virtualMethod);
            }
            collection.add(psiClassType);
        }
        List parameterTypes = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = parameterTypes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return InferenceKt.putAll(PsiSubstitutor.EMPTY, virtualMethod.getTypeParameters(), (PsiType[])thisCollection$iv.toArray(new PsiClassType[0]));
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return InferMethodParametersTypesIntention::getElementPredicate$lambda$7;
    }

    @Override
    protected boolean isStopElement(@Nullable PsiElement element) {
        return element instanceof GrOpenBlock || element instanceof GrMethod || super.isStopElement(element);
    }

    @Override
    @NotNull
    public String getText() {
        return GroovyBundle.message("infer.method.parameters.types", new Object[0]);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return GroovyBundle.message("infer.method.parameters.types.for.method.declaration", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getElementPredicate$lambda$7(PsiElement element) {
        if (!(element instanceof GrMethod)) return false;
        if (element instanceof GrOpenBlock) return false;
        GrParameter[] $this$any$iv = ((GrMethod)element).getParameters();
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            GrParameter element$iv;
            GrParameter it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (it.getTypeElement() == null) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

