/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.declaration;

import com.intellij.codeInsight.intention.impl.CreateFieldFromParameterActionBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class GrCreateFieldForParameterIntention
extends CreateFieldFromParameterActionBase {
    protected boolean isAvailable(@NotNull PsiParameter parameter) {
        PsiElement scope = parameter.getDeclarationScope();
        if (!(scope instanceof GrMethod)) {
            return false;
        }
        if (((GrMethod)scope).getContainingClass() == null) {
            return false;
        }
        return !GrCreateFieldForParameterIntention.checkAssignmentToFieldExists(parameter);
    }

    protected PsiType getSubstitutedType(@NotNull PsiParameter parameter) {
        return GroovyRefactoringUtil.getSubstitutedType((GrParameter)parameter);
    }

    private static boolean checkAssignmentToFieldExists(PsiParameter parameter) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter).findAll()) {
            GrAssignmentExpression parent2;
            GrExpression value2;
            PsiElement element = reference.getElement();
            if (!(element instanceof GrReferenceExpression) || !(element.getParent() instanceof GrAssignmentExpression) || ((GrAssignmentExpression)element.getParent()).getRValue() != element || !((value2 = (parent2 = (GrAssignmentExpression)element.getParent()).getLValue()) instanceof GrReferenceExpression) || !(((GrReferenceExpression)value2).resolve() instanceof PsiField)) continue;
            return true;
        }
        return false;
    }

    protected void performRefactoring(@NotNull Project project, @NotNull PsiClass targetClass, @NotNull PsiMethod method, @NotNull PsiParameter myParameter, PsiType type2, @NotNull String fieldName, boolean methodStatic, boolean isFinal) {
        GrOpenBlock block;
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        if (targetClass.findFieldByName(fieldName, false) == null) {
            String[] modifiers = GrCreateFieldForParameterIntention.getModifiers(methodStatic, isFinal);
            GrVariableDeclaration fieldDeclaration = factory.createFieldDeclaration(modifiers, fieldName, null, type2);
            GrVariableDeclaration inserted = (GrVariableDeclaration)targetClass.add((PsiElement)fieldDeclaration);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)inserted);
        }
        if ((block = ((GrMethod)method).getBlock()) == null) {
            return;
        }
        GrAssignmentExpression assignment = GrCreateFieldForParameterIntention.createAssignment(targetClass, myParameter, fieldName, methodStatic, factory);
        GrStatement anchor = GrCreateFieldForParameterIntention.getAnchor(block);
        GrStatement statement = block.addStatementBefore(assignment, anchor);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)statement);
    }

    private static GrAssignmentExpression createAssignment(PsiClass targetClass, PsiParameter myParameter, String fieldName, boolean methodStatic, GroovyPsiElementFactory factory) {
        StringBuilder builder = new StringBuilder();
        if (methodStatic) {
            builder.append(targetClass.getQualifiedName());
            builder.append('.');
        } else {
            builder.append("this.");
        }
        builder.append(fieldName);
        builder.append("=").append(myParameter.getName());
        return (GrAssignmentExpression)factory.createStatementFromText(builder.toString());
    }

    @Nullable
    private static GrStatement getAnchor(GrOpenBlock block) {
        Object[] statements2 = block.getStatements();
        GrStatement fist = (GrStatement)ArrayUtil.getFirstElement((Object[])statements2);
        if (fist instanceof GrConstructorInvocation) {
            return statements2.length > 1 ? statements2[1] : null;
        }
        return fist;
    }

    private static String[] getModifiers(boolean aStatic, boolean aFinal) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("private");
        if (aStatic) {
            list.add("static");
        }
        if (aFinal) {
            list.add("final");
        }
        return ArrayUtilRt.toStringArray(list);
    }
}

