/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.IndexingMethodConversionPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class IndexingMethodConversionIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new IndexingMethodConversionPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrMethodCallExpression callExpression = (GrMethodCallExpression)element;
        GrArgumentList argList = callExpression.getArgumentList();
        GrExpression[] arguments2 = argList.getExpressionArguments();
        GrReferenceExpression methodExpression = (GrReferenceExpression)callExpression.getInvokedExpression();
        IElementType referenceType = methodExpression.getDotTokenType();
        String methodName = methodExpression.getReferenceName();
        GrExpression qualifier = methodExpression.getQualifierExpression();
        if ("getAt".equals(methodName) || "get".equals(methodName)) {
            PsiImplUtil.replaceExpression(qualifier.getText() + "[" + arguments2[0].getText() + "]", callExpression);
        } else {
            PsiImplUtil.replaceExpression(qualifier.getText() + "[" + arguments2[0].getText() + "]=" + arguments2[1].getText(), callExpression);
        }
    }
}

