/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class GrConvertTypeCastToSafeCastIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (!(element instanceof GrTypeCastExpression)) {
            return;
        }
        GrExpression operand = ((GrTypeCastExpression)element).getOperand();
        GrTypeElement type2 = ((GrTypeCastExpression)element).getCastTypeElement();
        if (type2 == null) {
            return;
        }
        if (operand == null) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrExpression safeCast = factory.createExpressionFromText(operand.getText() + " as " + type2.getText());
        ((GrTypeCastExpression)element).replaceWithExpression(safeCast, true);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                return element instanceof GrTypeCastExpression && ((GrTypeCastExpression)element).getCastTypeElement() != null && ((GrTypeCastExpression)element).getOperand() != null;
            }
        };
    }
}

