/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class ConvertSimpleGetterToPropertyIntention
extends Intention {
    private static final String[] MODIFIERS_TO_CHECK = new String[]{"static", "private", "protected"};

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrMethod method = (GrMethod)element.getParent();
        GrOpenBlock block = method.getBlock();
        if (block == null) {
            return;
        }
        GrStatement statement = block.getStatements()[0];
        GrExpression value2 = statement instanceof GrReturnStatement ? ((GrReturnStatement)statement).getReturnValue() : (GrExpression)statement;
        String fieldName = GroovyPropertyUtils.getPropertyNameByGetter(method);
        if (fieldName == null) {
            return;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return;
        }
        ArrayList<String> modifiers = new ArrayList<String>();
        for (String modifier : MODIFIERS_TO_CHECK) {
            if (!method.hasModifierProperty(modifier)) continue;
            modifiers.add(modifier);
        }
        modifiers.add("final");
        GrTypeElement returnTypeElement = method.getReturnTypeElementGroovy();
        PsiType returnType2 = returnTypeElement == null ? null : returnTypeElement.getType();
        GrVariableDeclaration declaration = GroovyPsiElementFactory.getInstance(project).createFieldDeclaration(ArrayUtilRt.toStringArray(modifiers), fieldName, value2, returnType2);
        PsiElement replaced = method.replace(declaration);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replaced);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                PsiElement parent2 = element.getParent();
                if (!(parent2 instanceof GrMethod) || ((GrMethod)parent2).getNameIdentifierGroovy() != element) {
                    return false;
                }
                GrMethod method = (GrMethod)parent2;
                GrOpenBlock block = method.getBlock();
                if (block == null) {
                    return false;
                }
                GrStatement[] statements2 = block.getStatements();
                if (statements2.length != 1) {
                    return false;
                }
                if (!GroovyPropertyUtils.isSimplePropertyGetter(method)) {
                    return false;
                }
                if (GroovyPropertyUtils.findFieldForAccessor(method, true) != null) {
                    return false;
                }
                GrStatement statement = statements2[0];
                return statement instanceof GrReturnStatement && ((GrReturnStatement)statement).getReturnValue() != null || statement instanceof GrExpression && !PsiType.VOID.equals((Object)((GrExpression)statement).getType());
            }
        };
    }
}

