/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.google.common.collect.Lists;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.JavaThrownExceptionInfo;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.DefaultGroovyVariableNameValidator;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeInfoImpl;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureProcessor;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;

public class CreateParameterForFieldIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance(CreateParameterForFieldIntention.class);
    private static final Key<CachedValue<List<GrField>>> FIELD_CANDIDATES = Key.create((String)"Fields.candidates");

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        List<GrField> candidates = CreateParameterForFieldIntention.findFieldCandidates(element);
        if (candidates != null) {
            CreateParameterForFieldIntention.performForConstructor(element, project, editor, candidates);
        } else {
            List<GrMethod> constructors = CreateParameterForFieldIntention.findConstructorCandidates(element);
            CreateParameterForFieldIntention.performForField(element, project, editor, constructors);
        }
    }

    private static void performForField(PsiElement element, Project project, Editor editor, List<GrMethod> constructors) {
        GrField field = (GrField)PsiTreeUtil.getParentOfType((PsiElement)element, GrField.class);
        if (constructors.isEmpty()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (GrMethod constructor : constructors) {
                CreateParameterForFieldIntention.addParameter(field, constructor, project);
            }
            return;
        }
        JBPopupFactory.getInstance().createPopupChooserBuilder(constructors).setRenderer((ListCellRenderer)new MethodCellRenderer(true)).setTitle(GroovyIntentionsBundle.message("create.parameter.for.field.intention.name", new Object[0])).setMovable(true).setItemsChosenCallback(values -> {
            ArrayList selectedValues = Lists.newArrayList((Iterable)values);
            selectedValues.sort((o1, o2) -> o2.getParameterList().getParametersCount() - o1.getParameterList().getParametersCount());
            CommandProcessor.getInstance().executeCommand(project, () -> {
                for (GrMethod selectedValue : selectedValues) {
                    LOG.assertTrue(selectedValue.isValid());
                    CreateParameterForFieldIntention.addParameter(field, selectedValue, project);
                }
            }, GroovyIntentionsBundle.message("create.parameter.for.field.intention.name", new Object[0]), null);
        }).createPopup().showInBestPositionFor(editor);
    }

    private static void performForConstructor(PsiElement element, Project project, Editor editor, List<GrField> candidates) {
        GrMethod constructor = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)element, GrMethod.class);
        if (candidates.isEmpty()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (GrField candidate : candidates) {
                CreateParameterForFieldIntention.addParameter(candidate, constructor, project);
            }
            return;
        }
        JBPopupFactory.getInstance().createPopupChooserBuilder(candidates).setRenderer((ListCellRenderer)new DefaultPsiElementCellRenderer()).setTitle(GroovyIntentionsBundle.message("create.parameter.for.field.intention.name", new Object[0])).setMovable(true).setItemsChosenCallback(selectedValues -> CommandProcessor.getInstance().executeCommand(project, () -> {
            for (GrField selectedValue : selectedValues) {
                LOG.assertTrue(selectedValue.isValid());
                CreateParameterForFieldIntention.addParameter(selectedValue, constructor, project);
            }
        }, GroovyIntentionsBundle.message("create.parameter.for.field.intention.name", new Object[0]), null)).createPopup().showInBestPositionFor(editor);
    }

    private static void addParameter(final GrField selectedValue, final GrMethod constructor, final Project project) {
        ArrayList<GrParameterInfo> parameters2 = new ArrayList<GrParameterInfo>();
        GrParameter[] constructorParameters = constructor.getParameters();
        for (int i2 = 0; i2 < constructorParameters.length; ++i2) {
            parameters2.add(new GrParameterInfo(constructorParameters[i2], i2));
        }
        Object[] suggestedNames = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName((VariableKind)VariableKind.PARAMETER, (String)selectedValue.getName(), null, null).names;
        DefaultGroovyVariableNameValidator nameValidator = new DefaultGroovyVariableNameValidator(constructor, Collections.emptyList(), false);
        String parameterName = (String)ContainerUtil.find((Object[])suggestedNames, name -> !nameValidator.validateName((String)name, false).isEmpty());
        if (parameterName == null) {
            parameterName = nameValidator.validateName((String)suggestedNames[0], true);
        }
        parameters2.add(new GrParameterInfo(parameterName, "null", "", selectedValue.getTypeGroovy(), -1, false));
        PsiClassType[] exceptionTypes = constructor.getThrowsList().getReferencedTypes();
        ThrownExceptionInfo[] thrownExceptionInfos = new ThrownExceptionInfo[exceptionTypes.length];
        for (int i3 = 0; i3 < exceptionTypes.length; ++i3) {
            new JavaThrownExceptionInfo(i3, exceptionTypes[i3]);
        }
        GrChangeInfoImpl grChangeInfo = new GrChangeInfoImpl(constructor, null, null, constructor.getName(), parameters2, thrownExceptionInfos, false);
        final String finalParameterName = parameterName;
        GrChangeSignatureProcessor processor = new GrChangeSignatureProcessor(project, grChangeInfo){

            protected void performRefactoring(UsageInfo @NotNull [] usages) {
                super.performRefactoring(usages);
                GrOpenBlock block = constructor.getBlock();
                LOG.assertTrue(block != null);
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
                String text = StringUtil.equals((CharSequence)selectedValue.getName(), (CharSequence)finalParameterName) ? "this." + selectedValue.getName() + " = " + finalParameterName : selectedValue.getName() + " = " + finalParameterName;
                GrStatement assignment = factory.createStatementFromText(text);
                GrStatement statement = block.addStatementBefore(assignment, null);
                GrReferenceExpression ref2 = (GrReferenceExpression)((GrAssignmentExpression)statement).getLValue();
                if (!PsiManager.getInstance((Project)project).areElementsEquivalent(ref2.resolve(), (PsiElement)selectedValue)) {
                    PsiUtil.qualifyMemberReference(ref2, selectedValue, selectedValue.getName());
                }
            }
        };
        processor.run();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new MyPredicate();
    }

    @Nullable
    private static List<GrField> findFieldCandidates(PsiElement element) {
        GrMethod constructor = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)element, GrMethod.class);
        if (constructor == null || !constructor.isConstructor()) {
            return null;
        }
        if (constructor.getBlock() == null) {
            return null;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)constructor.getBlock(), (PsiElement)element, (boolean)false)) {
            return null;
        }
        PsiClass clazz = constructor.getContainingClass();
        if (!(clazz instanceof GrTypeDefinition)) {
            return null;
        }
        return CreateParameterForFieldIntention.findCandidatesCached(constructor, (GrTypeDefinition)clazz);
    }

    private static List<GrField> findCandidates(PsiMethod constructor, final GrTypeDefinition clazz) {
        GrOpenBlock block;
        final ArrayList<GrField> usedFields = new ArrayList<GrField>();
        GrOpenBlock grOpenBlock = block = constructor instanceof GrMethod ? ((GrMethod)constructor).getBlock() : null;
        if (block == null) {
            return usedFields;
        }
        final PsiManager manager = clazz.getManager();
        block.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
                super.visitReferenceExpression(referenceExpression);
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof GrField && manager.areElementsEquivalent((PsiElement)((GrField)resolved).getContainingClass(), (PsiElement)clazz) && PsiUtil.isAccessedForWriting(referenceExpression)) {
                    usedFields.add((GrField)resolved);
                }
            }

            @Override
            public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
            }

            @Override
            public void visitClosure(@NotNull GrClosableBlock closure) {
            }
        });
        ArrayList<GrField> fields = new ArrayList<GrField>();
        for (GrField field : clazz.getFields()) {
            if (field.getInitializerGroovy() != null || ContainerUtil.find(usedFields, o -> manager.areElementsEquivalent((PsiElement)o, (PsiElement)field)) != null) continue;
            fields.add(field);
        }
        return fields;
    }

    private static List<GrField> findCandidatesCached(PsiMethod constructor, GrTypeDefinition clazz) {
        CachedValue value2 = (CachedValue)constructor.getUserData(FIELD_CANDIDATES);
        if (value2 != null && value2.getValue() != null) {
            return (List)value2.getValue();
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)constructor.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(CreateParameterForFieldIntention.findCandidates(constructor, clazz), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
        constructor.putUserData(FIELD_CANDIDATES, (Object)cachedValue);
        return (List)cachedValue.getValue();
    }

    @Nullable
    private static List<GrMethod> findConstructorCandidates(PsiElement element) {
        GrField field = (GrField)PsiTreeUtil.getParentOfType((PsiElement)element, GrField.class);
        if (field == null) {
            return null;
        }
        PsiClass containingClass = field.getContainingClass();
        if (!(containingClass instanceof GrTypeDefinition)) {
            return null;
        }
        return CreateParameterForFieldIntention.findConstructorCandidates(field, (GrTypeDefinition)containingClass);
    }

    private static List<GrMethod> findConstructorCandidates(@NotNull GrField field, @NotNull GrTypeDefinition psiClass) {
        ArrayList<GrMethod> result2 = new ArrayList<GrMethod>();
        PsiMethod[] constructors = psiClass.getConstructors();
        PsiManager manager = field.getManager();
        for (PsiMethod constructor : constructors) {
            List<GrField> fields = CreateParameterForFieldIntention.findCandidatesCached(constructor, psiClass);
            if (ContainerUtil.find(fields, grField -> manager.areElementsEquivalent((PsiElement)grField, (PsiElement)field)) == null) continue;
            result2.add((GrMethod)constructor);
        }
        return result2;
    }

    static class MyPredicate
    implements PsiElementPredicate {
        MyPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            List<GrField> candidates = CreateParameterForFieldIntention.findFieldCandidates(element);
            if (candidates != null && !candidates.isEmpty()) {
                return true;
            }
            List<GrMethod> constructors = CreateParameterForFieldIntention.findConstructorCandidates(element);
            return constructors != null && !constructors.isEmpty();
        }
    }
}

