/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.geb;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightModifierList;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GebUtil {
    public static boolean contributeMembersInsideTest(PsiScopeProcessor processor, PsiElement place, ResolveState state) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)place.getProject());
        PsiClass browserClass = facade.findClass("geb.Browser", place.getResolveScope());
        if (browserClass != null) {
            if (!browserClass.processDeclarations(processor, state, null, place)) {
                return false;
            }
            PsiClass pageClass = facade.findClass("geb.Page", place.getResolveScope());
            if (pageClass != null && !pageClass.processDeclarations(processor, state, null, place)) {
                return false;
            }
        }
        return true;
    }

    public static Map<String, PsiMember> getContentElements(@NotNull PsiClass pageOrModuleClass) {
        return (Map)CachedValuesManager.getCachedValue((PsiElement)pageOrModuleClass, () -> CachedValueProvider.Result.create(GebUtil.calculateContentElements(pageOrModuleClass), (Object[])new Object[]{pageOrModuleClass}));
    }

    private static Map<String, PsiMember> calculateContentElements(@NotNull PsiClass pageOrModuleClass) {
        PsiField contentField = pageOrModuleClass.findFieldByName("content", false);
        if (!(contentField instanceof GrField)) {
            return Collections.emptyMap();
        }
        GrExpression initializer = ((GrField)contentField).getInitializerGroovy();
        if (!(initializer instanceof GrClosableBlock)) {
            return Collections.emptyMap();
        }
        HashMap<String, PsiMember> res = new HashMap<String, PsiMember>();
        PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)pageOrModuleClass.getManager(), (GlobalSearchScope)pageOrModuleClass.getResolveScope());
        for (PsiElement e = initializer.getFirstChild(); e != null; e = e.getNextSibling()) {
            GrClosableBlock block;
            GrExpression[] arguments2;
            String name;
            GrMethodCall methodCall;
            GrExpression invokedExpression;
            if (!(e instanceof GrMethodCall) || !((invokedExpression = (methodCall = (GrMethodCall)e).getInvokedExpression()) instanceof GrReferenceExpression) || ((GrReferenceExpression)invokedExpression).isQualified() || (name = ((GrReferenceExpression)invokedExpression).getReferenceName()) == null || (arguments2 = PsiUtil.getAllArguments((GrCall)e)).length == 0) continue;
            if (arguments2.length == 1 && arguments2[0] instanceof GrClosableBlock) {
                block = (GrClosableBlock)arguments2[0];
            } else {
                if (arguments2.length != 2 || arguments2[0] != null || !(arguments2[1] instanceof GrClosableBlock)) continue;
                block = (GrClosableBlock)arguments2[1];
            }
            Object target = block.hasParametersSection() ? GebUtil.extractMethodForContent(pageOrModuleClass, name, invokedExpression, block) : GebUtil.extractFieldForContent(pageOrModuleClass, (PsiType)objectType, name, invokedExpression, block);
            res.put(name, (PsiMember)target);
        }
        return res;
    }

    @NotNull
    private static PsiField extractFieldForContent(@NotNull PsiClass pageOrModuleClass, @NotNull PsiType objectType, String name, @NotNull GrExpression invokedExpression, final @NotNull GrClosableBlock block) {
        GrLightField field = new GrLightField(pageOrModuleClass, name, objectType, invokedExpression){

            @NotNull
            public PsiType getType() {
                PsiType type2 = block.getReturnType();
                return type2 != null ? type2 : super.getType();
            }

            @Override
            public PsiType getDeclaredType() {
                return null;
            }
        };
        ((GrLightModifierList)field.getModifierList()).addModifier(8);
        return field;
    }

    @NotNull
    private static PsiMethod extractMethodForContent(@NotNull PsiClass pageOrModuleClass, @NotNull String name, @NotNull GrExpression invokedExpression, final @NotNull GrClosableBlock block) {
        GrLightMethodBuilder method = new GrLightMethodBuilder(pageOrModuleClass.getManager(), name){

            @Override
            public PsiType getReturnType() {
                return block.getReturnType();
            }
        };
        method.setContainingClass(pageOrModuleClass);
        method.addModifier(8);
        method.setNavigationElement(invokedExpression);
        for (GrParameter parameter : block.getAllParameters()) {
            method.addParameter(parameter);
        }
        return method;
    }
}

