/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.formatter.AlignmentProvider;
import org.jetbrains.plugins.groovy.formatter.GroovyBlockProducer;

public class FormattingContext {
    private final CommonCodeStyleSettings mySettings;
    private final GroovyCodeStyleSettings myGroovySettings;
    private final AlignmentProvider myAlignmentProvider;
    private final boolean myForbidWrapping;
    private final boolean myForbidNewLineInSpacing;
    private final GroovyBlockProducer myGroovyBlockProducer;

    public FormattingContext(@NotNull CommonCodeStyleSettings settings, @NotNull AlignmentProvider provider2, @NotNull GroovyCodeStyleSettings groovySettings, boolean forbidWrapping, boolean forbidNewLineInSpacing, @NotNull GroovyBlockProducer producer) {
        this.mySettings = settings;
        this.myAlignmentProvider = provider2;
        this.myGroovySettings = groovySettings;
        this.myForbidWrapping = forbidWrapping;
        this.myForbidNewLineInSpacing = forbidNewLineInSpacing;
        this.myGroovyBlockProducer = producer;
    }

    public FormattingContext(@NotNull CommonCodeStyleSettings settings, @NotNull AlignmentProvider provider2, @NotNull GroovyCodeStyleSettings groovySettings, boolean forbidWrapping) {
        this(settings, provider2, groovySettings, forbidWrapping, false, GroovyBlockProducer.DEFAULT);
    }

    public CommonCodeStyleSettings getSettings() {
        return this.mySettings;
    }

    public AlignmentProvider getAlignmentProvider() {
        return this.myAlignmentProvider;
    }

    public GroovyCodeStyleSettings getGroovySettings() {
        return this.myGroovySettings;
    }

    public FormattingContext createContext(boolean forbidWrapping, boolean forbidNewLineInSpacing) {
        return new FormattingContext(this.mySettings, this.myAlignmentProvider, this.myGroovySettings, this.myForbidWrapping || forbidWrapping, this.myForbidNewLineInSpacing || forbidNewLineInSpacing, this.myGroovyBlockProducer);
    }

    public boolean isForbidWrapping() {
        return this.myForbidWrapping;
    }

    public boolean isForbidNewLineInSpacing() {
        return this.myForbidNewLineInSpacing;
    }

    public Block createBlock(@NotNull ASTNode node, @NotNull Indent indent, @Nullable Wrap wrap) {
        return this.myGroovyBlockProducer.generateBlock(node, indent, wrap, this);
    }
}

