/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlignmentProvider {
    private final Map<PsiElement, Aligner> myElement2Aligner = new HashMap<PsiElement, Aligner>();

    public void addPair(@NotNull PsiElement e1, @NotNull PsiElement e2, boolean allowBackwardShift) {
        Aligner aligner = this.createAligner(allowBackwardShift);
        aligner.append(e1);
        aligner.append(e2);
    }

    @Nullable
    public Alignment getAlignment(@NotNull PsiElement e) {
        Aligner aligner = this.myElement2Aligner.get(e);
        return aligner == null ? null : aligner.getAlignment();
    }

    @NotNull
    public Aligner createAligner(boolean allowBackwardShift) {
        return new Aligner(allowBackwardShift, Alignment.Anchor.LEFT);
    }

    @NotNull
    public Aligner createAligner(PsiElement element, boolean allowBackwardShift, Alignment.Anchor anchor) {
        Aligner aligner = new Aligner(allowBackwardShift, anchor);
        aligner.append(element);
        return aligner;
    }

    public final class Aligner {
        private final Lazy<Alignment> myAlignment = LazyKt.lazy(() -> Alignment.createAlignment((boolean)allowBackwardShift, (Alignment.Anchor)anchor));

        private Aligner(@NotNull boolean allowBackwardShift, Alignment.Anchor anchor) {
        }

        public void append(@Nullable PsiElement element) {
            if (element == null) {
                return;
            }
            assert (!AlignmentProvider.this.myElement2Aligner.containsKey(element) || AlignmentProvider.this.myElement2Aligner.get(element) == this);
            AlignmentProvider.this.myElement2Aligner.put(element, this);
        }

        @NotNull
        public Alignment getAlignment() {
            return (Alignment)this.myAlignment.getValue();
        }
    }
}

