/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import org.jetbrains.plugins.groovy.GroovyFileType;

public final class GroovyScopeUtil {
    public static SearchScope restrictScopeToGroovyFiles(SearchScope originalScope) {
        FileType[] groovyEnabledFileTypes = GroovyFileType.getGroovyEnabledFileTypes();
        return PsiSearchScopeUtil.restrictScopeTo((SearchScope)originalScope, (FileType[])groovyEnabledFileTypes);
    }

    public static SearchScope restrictScopeToGroovyFiles(SearchScope originalScope, SearchScope effectiveScope) {
        SearchScope restricted = GroovyScopeUtil.restrictScopeToGroovyFiles(originalScope);
        return restricted.intersectWith(effectiveScope);
    }

    public static SearchScope getEffectiveScope(PsiMethod ... methods) {
        SearchScope accessScope = methods[0].getUseScope();
        for (int i2 = 1; i2 < methods.length; ++i2) {
            PsiMethod method1 = methods[i2];
            accessScope = accessScope.union(method1.getUseScope());
        }
        return accessScope;
    }
}

