/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.findUsages.GrHighlightExitPointHandler;
import org.jetbrains.plugins.groovy.findUsages.GrHighlightOverridingMethodsHandler;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GrHighlightHandlerFactory
extends HighlightUsagesHandlerFactoryBase {
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        ASTNode node = target.getNode();
        if (node == null) {
            return null;
        }
        IElementType type2 = node.getElementType();
        if (!(type2 instanceof GroovyElementType)) {
            return null;
        }
        if (type2 == GroovyTokenTypes.kIMPLEMENTS || type2 == GroovyTokenTypes.kEXTENDS) {
            PsiElement parent2 = target.getParent();
            if (!(parent2 instanceof GrReferenceList)) {
                return null;
            }
            PsiElement grand = parent2.getParent();
            if (!(grand instanceof GrTypeDefinition)) {
                return null;
            }
            return new GrHighlightOverridingMethodsHandler(editor, file, target, (GrTypeDefinition)grand);
        }
        if (type2 == GroovyTokenTypes.kRETURN || type2 == GroovyTokenTypes.kTHROW) {
            return new GrHighlightExitPointHandler(editor, file, target);
        }
        return null;
    }
}

