/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;

public class GrHighlightExitPointHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    private final PsiElement myTarget;

    protected GrHighlightExitPointHandler(Editor editor, PsiFile file, PsiElement target) {
        super(editor, file);
        this.myTarget = target;
    }

    @NotNull
    public List<PsiElement> getTargets() {
        return Collections.singletonList(this.myTarget);
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
        selectionConsumer.consume(targets);
    }

    public void computeUsages(@NotNull List<? extends PsiElement> targets) {
        PsiElement parent2 = this.myTarget.getParent();
        if (!(parent2 instanceof GrReturnStatement) && !(parent2 instanceof GrThrowStatement)) {
            return;
        }
        GrControlFlowOwner flowOwner = ControlFlowUtils.findControlFlowOwner(parent2);
        ControlFlowUtils.visitAllExitPoints(flowOwner, new ControlFlowUtils.ExitPointVisitor(){

            @Override
            public boolean visitExitPoint(Instruction instruction, @Nullable GrExpression returnValue) {
                PsiElement returnElement = instruction.getElement();
                if (returnElement != null && GrHighlightExitPointHandler.isCorrectReturn(returnElement)) {
                    TextRange range = returnElement.getTextRange();
                    GrHighlightExitPointHandler.this.myReadUsages.add(range);
                }
                return true;
            }
        });
    }

    private static boolean isCorrectReturn(@Nullable PsiElement e) {
        return e instanceof GrReturnStatement || e instanceof GrThrowStatement || e instanceof GrExpression;
    }

    @Nullable
    public String getFeatureId() {
        return "codeassists.highlight.return";
    }
}

