/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.extensions;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.extensions.impl.StringTypeCondition;

public class GroovyMethodDescriptor {
    private static final String ATTR_NAMES_DELIMITER = " \t\n\r,;";
    @Attribute(value="name")
    public String methodName;
    @Attribute(value="checkParamsType")
    public Boolean checkParamsType;
    @Property(surroundWithTag=false)
    @XCollection
    public Param[] params;
    @Attribute(value="returnType")
    public String returnType;
    @Attribute(value="returnTypeCalculator")
    public String returnTypeCalculator;
    @Attribute(value="namedArgs")
    public String namedArgs;
    @Attribute(value="namedArgsProvider")
    public String namedArgsProvider;
    @Attribute(value="namedArgsShowFirst")
    public Boolean isNamedArgsShowFirst;
    @Property(surroundWithTag=false)
    @XCollection
    public NamedArgument[] myArguments;
    @Property(surroundWithTag=false)
    @XCollection
    public ClosureArgument[] myClosureArguments;

    @Nullable
    public List<String> getParams() {
        if (this.params != null) {
            assert (this.checkParamsType == null || this.checkParamsType.booleanValue());
            String[] paramsTypeNames = new String[this.params.length];
            for (int i2 = 0; i2 < this.params.length; ++i2) {
                String typeName = this.params[i2].type;
                assert (StringUtil.isNotEmpty((String)typeName));
                paramsTypeNames[i2] = typeName;
            }
            return Arrays.asList(paramsTypeNames);
        }
        if (this.checkParamsType != null && this.checkParamsType.booleanValue()) {
            return Collections.emptyList();
        }
        return null;
    }

    @Nullable
    public Map<String, NamedArgumentDescriptor> getArgumentsMap() {
        if (this.myArguments == null && this.namedArgs == null) {
            assert (this.isNamedArgsShowFirst == null);
            return null;
        }
        HashMap<String, NamedArgumentDescriptor> res = new HashMap<String, NamedArgumentDescriptor>();
        if (this.myArguments != null) {
            for (NamedArgument arguments2 : this.myArguments) {
                NamedArgumentDescriptor descriptor = GroovyMethodDescriptor.getDescriptor(this.isNamedArgsShowFirst, arguments2.isFirst, arguments2.type);
                for (String name : arguments2.getNames()) {
                    NamedArgumentDescriptor oldValue = res.put(name, descriptor);
                    assert (oldValue == null);
                }
            }
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.namedArgs)) {
            NamedArgumentDescriptor descriptor = GroovyMethodDescriptor.getDescriptor(this.isNamedArgsShowFirst, null, null);
            StringTokenizer st = new StringTokenizer(this.namedArgs, ATTR_NAMES_DELIMITER);
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                NamedArgumentDescriptor oldValue = res.put(name, descriptor);
                assert (oldValue == null) : "Duplicated attribute name: " + name;
            }
        }
        return res;
    }

    private static NamedArgumentDescriptor getDescriptor(@Nullable Boolean methodFirstFlag, @Nullable Boolean attrFirstFlag, @Nullable String type2) {
        boolean showFirst;
        Boolean objShowFirst = attrFirstFlag;
        if (objShowFirst == null) {
            objShowFirst = methodFirstFlag;
        }
        boolean bl = showFirst = objShowFirst == null || objShowFirst != false;
        if (StringUtil.isEmptyOrSpaces((String)type2)) {
            return showFirst ? NamedArgumentDescriptor.SIMPLE_ON_TOP : NamedArgumentDescriptor.SIMPLE_NORMAL;
        }
        return showFirst ? new StringTypeCondition(type2.trim()) : new StringTypeCondition(NamedArgumentDescriptor.Priority.NORMAL, type2.trim());
    }

    @Tag(value="param")
    public static class Param {
        public static final Param[] EMPTY_ARRAY = new Param[0];
        @Attribute(value="type")
        public String type;
    }

    @Tag(value="namedArgument")
    public static class NamedArgument {
        @Attribute(value="type")
        public String type;
        @Attribute(value="showFirst")
        public Boolean isFirst;
        @Attribute(value="name")
        public String name;
        @Attribute(value="referenceProvider")
        public String referenceProvider;
        @Attribute(value="values")
        public String values;

        protected Iterable<String> getNames() {
            assert (!StringUtil.isEmptyOrSpaces((String)this.name));
            return StringUtil.tokenize((String)this.name, (String)GroovyMethodDescriptor.ATTR_NAMES_DELIMITER);
        }
    }

    @Tag(value="closureArgument")
    public static class ClosureArgument {
        @Attribute(value="index")
        public int index;
        @Attribute(value="methodContributor")
        public String methodContributor;
    }
}

