/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.ext.spock.SpockUtils;
import org.jetbrains.plugins.groovy.ext.spock.SpockVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class SpockUnrollReferenceProvider
extends PsiReferenceProvider {
    private static final Pattern PATTERN = Pattern.compile("\\#([\\w_]+)");
    @NlsSafe
    private static final String UNROLL = "Unroll";
    @NlsSafe
    private static final String SPOCK_LANG_UNROLL = "spock.lang.Unroll";

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        GrAnnotationNameValuePair nvp = (GrAnnotationNameValuePair)element.getParent();
        String name = nvp.getName();
        if (name != null && !name.equals("value")) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement argumentList = nvp.getParent();
        if (!(argumentList instanceof GrAnnotationArgumentList)) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement eAnnotation = argumentList.getParent();
        if (!(eAnnotation instanceof GrAnnotation)) {
            return PsiReference.EMPTY_ARRAY;
        }
        GrAnnotation annotation = (GrAnnotation)eAnnotation;
        String shortName = annotation.getShortName();
        if (!shortName.equals(UNROLL) && !shortName.equals(SPOCK_LANG_UNROLL)) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement modifierList = annotation.getParent();
        if (!(modifierList instanceof GrModifierList)) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement eMethod = modifierList.getParent();
        if (!(eMethod instanceof GrMethod)) {
            return PsiReference.EMPTY_ARRAY;
        }
        GrMethod method = (GrMethod)eMethod;
        TextRange rangeInElement = ElementManipulators.getValueTextRange((PsiElement)element);
        String text = rangeInElement.substring(element.getText());
        ArrayList<SpockVariableReference> references = new ArrayList<SpockVariableReference>();
        Matcher matcher = PATTERN.matcher(text);
        while (matcher.find()) {
            TextRange range = new TextRange(rangeInElement.getStartOffset() + matcher.start(1), rangeInElement.getStartOffset() + matcher.end(1));
            references.add(new SpockVariableReference(element, range, references, method));
        }
        return references.toArray(PsiReference.EMPTY_ARRAY);
    }

    private static class SpockVariableReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiElement myLeafElement;
        private final List<? extends SpockVariableReference> myReferences;
        private final GrMethod myMethod;

        SpockVariableReference(PsiElement element, TextRange range, List<? extends SpockVariableReference> references, GrMethod method) {
            super(element, range);
            this.myReferences = references;
            this.myMethod = method;
            this.myLeafElement = element.getFirstChild();
        }

        public PsiElement resolve() {
            String value2;
            Map<String, SpockVariableDescriptor> variableMap = SpockUtils.getVariableMap(this.myMethod);
            SpockVariableDescriptor descriptor = variableMap.get(value2 = this.getValue());
            if (descriptor == null) {
                return null;
            }
            return descriptor.getVariable();
        }

        public Object @NotNull [] getVariants() {
            Map<String, SpockVariableDescriptor> variableMap = SpockUtils.getVariableMap(this.myMethod);
            Object[] res = new Object[variableMap.size()];
            int i2 = 0;
            for (SpockVariableDescriptor descriptor : variableMap.values()) {
                res[i2++] = descriptor.getVariable();
            }
            return res;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (this.getElement().getFirstChild() != this.myLeafElement) {
                return this.getElement();
            }
            String oldValue = this.getValue();
            PsiElement res = null;
            int i2 = this.myReferences.size();
            while (--i2 >= 0) {
                SpockVariableReference reference = this.myReferences.get(i2);
                if (!oldValue.equals(reference.getCanonicalText())) continue;
                res = reference.superHandleRename(newElementName);
            }
            return res;
        }

        public PsiElement superHandleRename(String newName) {
            return super.handleElementRename(newName);
        }
    }
}

