/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.ext.spock.SpockUtils;
import org.jetbrains.plugins.groovy.ext.spock.SpockVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class SpockPomDeclarationSearcher
extends PomDeclarationSearcher {
    public void findDeclarationsAt(@NotNull PsiElement element, int offsetInElement, @NotNull Consumer<? super PomTarget> consumer) {
        String name = SpockUtils.getNameByReference(element);
        if (name == null) {
            return;
        }
        GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)element, GrMethod.class);
        if (method == null) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"spock.lang.Specification")) {
            return;
        }
        Map<String, SpockVariableDescriptor> cachedValue = SpockUtils.getVariableMap(method);
        SpockVariableDescriptor descriptor = cachedValue.get(name);
        if (descriptor == null) {
            return;
        }
        if (descriptor.getNavigationElement() == element) {
            consumer.consume((Object)descriptor.getVariable());
        }
    }
}

