/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.TypedHandlerUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GroovyTypedHandler
extends TypedHandlerDelegate {
    private boolean myJavaLTTyped;

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        int offsetBefore = editor.getCaretModel().getOffset();
        boolean bl = this.myJavaLTTyped = '<' == c && file instanceof GroovyFile && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && GroovyTypedHandler.isAfterClassLikeIdentifier(offsetBefore, editor);
        if ('>' == c && file instanceof GroovyFile && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && TypedHandlerUtil.handleGenericGT((Editor)editor, (IElementType)GroovyTokenTypes.mLT, (IElementType)GroovyTokenTypes.mGT, (TokenSet)TokenSets.INVALID_INSIDE_REFERENCE)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        if (c == '@' && file instanceof GroovyFile) {
            GroovyTypedHandler.autoPopupMemberLookup(project, editor, (Condition<PsiFile>)((Condition)file12 -> {
                int offset = editor.getCaretModel().getOffset();
                PsiElement lastElement = file12.findElementAt(offset - 1);
                if (lastElement == null) {
                    return false;
                }
                PsiElement prevSibling = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastElement);
                return prevSibling != null && ".".equals(prevSibling.getText());
            }));
        }
        if (c == '&' && file instanceof GroovyFile) {
            GroovyTypedHandler.autoPopupMemberLookup(project, editor, (Condition<PsiFile>)((Condition)file1 -> {
                int offset = editor.getCaretModel().getOffset();
                PsiElement lastElement = file1.findElementAt(offset - 1);
                return lastElement != null && ".&".equals(lastElement.getText());
            }));
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static void autoPopupMemberLookup(Project project, Editor editor, Condition<PsiFile> condition) {
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, condition);
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (this.myJavaLTTyped) {
            this.myJavaLTTyped = false;
            TypedHandlerUtil.handleAfterGenericLT((Editor)editor, (IElementType)GroovyTokenTypes.mLT, (IElementType)GroovyTokenTypes.mGT, (TokenSet)TokenSets.INVALID_INSIDE_REFERENCE);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public static boolean isAfterClassLikeIdentifier(int offset, Editor editor) {
        HighlighterIterator iterator2 = editor.getHighlighter().createIterator(offset);
        if (iterator2.atEnd()) {
            return false;
        }
        if (iterator2.getStart() > 0) {
            iterator2.retreat();
        }
        return TypedHandlerUtil.isClassLikeIdentifier((int)offset, (Editor)editor, (HighlighterIterator)iterator2, (IElementType)GroovyTokenTypes.mIDENT);
    }
}

