/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.editor.HandlerUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GStringTypedActionHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (c != '{' || !HandlerUtils.canBeInvoked(editor, project)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (!(file instanceof GroovyFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        int caret = editor.getCaretModel().getOffset();
        EditorHighlighter highlighter = editor.getHighlighter();
        if (caret < 1) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        HighlighterIterator iterator2 = highlighter.createIterator(caret - 1);
        if (iterator2.getTokenType() != GroovyTokenTypes.mLCURLY) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        iterator2.retreat();
        if (iterator2.atEnd() || iterator2.getTokenType() != GroovyTokenTypes.mDOLLAR) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        iterator2.advance();
        if (iterator2.atEnd()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        iterator2.advance();
        if (iterator2.getTokenType() != GroovyTokenTypes.mGSTRING_BEGIN) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        editor.getDocument().insertString(caret, (CharSequence)"}");
        return TypedHandlerDelegate.Result.STOP;
    }
}

