/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.ClosureDescriptor;
import org.jetbrains.plugins.groovy.dsl.CustomMembersHolderImpl;
import org.jetbrains.plugins.groovy.dsl.Descriptor;
import org.jetbrains.plugins.groovy.dsl.DescriptorsKt;
import org.jetbrains.plugins.groovy.dsl.GdslMembersHolderConsumer;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.NamedParameterDescriptor;
import org.jetbrains.plugins.groovy.dsl.dsltop.GdslMembersProvider;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class CustomMembersGenerator
extends GroovyObjectSupport
implements GdslMembersHolderConsumer {
    private static final GdslMembersProvider[] PROVIDERS = (GdslMembersProvider[])GdslMembersProvider.EP_NAME.getExtensions();
    @NonNls
    public static final String THROWS = "throws";
    private FList<@NotNull Descriptor> myDeclarations = FList.emptyList();
    private final List<CustomMembersHolder> myMemberHolders = new ArrayList<CustomMembersHolder>();
    private final GroovyClassDescriptor myDescriptor;
    @Nullable
    private final Map<String, List> myBindings;

    public CustomMembersGenerator(@NotNull GroovyClassDescriptor descriptor, @Nullable Map<String, List> bindings2) {
        this.myDescriptor = descriptor;
        this.myBindings = bindings2;
    }

    @Override
    public PsiElement getPlace() {
        return this.myDescriptor.getPlace();
    }

    @Override
    @Nullable
    public PsiClass getClassType() {
        return this.getPsiClass();
    }

    @Override
    public PsiType getPsiType() {
        return this.myDescriptor.getPsiType();
    }

    @Override
    @Nullable
    public PsiClass getPsiClass() {
        return this.myDescriptor.getPsiClass();
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myDescriptor.getResolveScope();
    }

    @Override
    public Project getProject() {
        return this.myDescriptor.getProject();
    }

    @Nullable
    public List<CustomMembersHolder> getMembersHolder() {
        if (!this.myDeclarations.isEmpty()) {
            this.addMemberHolder(new CustomMembersHolderImpl(this.myDeclarations));
        }
        return this.myMemberHolders;
    }

    @Override
    public void addMemberHolder(CustomMembersHolder holder) {
        this.myMemberHolders.add(holder);
    }

    private Object[] constructNewArgs(Object[] args) {
        Object[] newArgs = new Object[args.length + 1];
        for (int i2 = 0; i2 < args.length; ++i2) {
            newArgs[i2] = args[i2];
        }
        newArgs[args.length] = this;
        return newArgs;
    }

    public void property(Map<Object, Object> args) {
        if (args == null) {
            return;
        }
        String name = (String)args.get("name");
        Object type2 = args.get("type");
        Object doc = args.get("doc");
        Object docUrl = args.get("docUrl");
        Boolean isStatic = (Boolean)args.get("isStatic");
        HashMap<@NonNls String, Object> getter = new HashMap<String, Object>();
        getter.put("name", GroovyPropertyUtils.getGetterNameNonBoolean(name));
        getter.put("type", type2);
        getter.put("isStatic", isStatic);
        getter.put("doc", doc);
        getter.put("docUrl", docUrl);
        this.method(getter);
        HashMap<@NonNls String, @NonNls Object> setter = new HashMap<String, Object>();
        setter.put("name", GroovyPropertyUtils.getSetterName(name));
        setter.put("type", "void");
        setter.put("isStatic", isStatic);
        setter.put("doc", doc);
        setter.put("docUrl", docUrl);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(name, type2);
        setter.put("params", param);
        this.method(setter);
    }

    public void constructor(Map<Object, Object> args) {
        if (args == null) {
            return;
        }
        args.put("constructor", true);
        this.method(args);
    }

    public NamedParameterDescriptor parameter(Map<?, ?> args) {
        return DescriptorsKt.parseNamedParameter(args);
    }

    public void method(Map<?, ?> args) {
        if (args == null) {
            return;
        }
        this.myDeclarations = this.myDeclarations.prepend((Object)DescriptorsKt.parseMethod(args));
    }

    public void methodCall(Closure<Map<Object, Object>> generator) {
        PsiElement parent2;
        PsiElement place = this.myDescriptor.getPlace();
        if (CustomMembersGenerator.isMethodCall(place, parent2 = place.getParent())) {
            assert (parent2 instanceof GrMethodCall && place instanceof GrReferenceExpression);
            GrReferenceExpression ref2 = (GrReferenceExpression)place;
            Object[] argTypes = PsiUtil.getArgumentTypes(ref2, false);
            if (argTypes == null) {
                return;
            }
            String[] types = (String[])ContainerUtil.map((Object[])argTypes, PsiType::getCanonicalText, (Object[])new String[argTypes.length]);
            generator.setDelegate((Object)this);
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("name", ref2.getReferenceName());
            args.put("argumentTypes", types);
            generator.call(args);
        }
    }

    private static boolean isMethodCall(PsiElement place, PsiElement parent2) {
        return place instanceof GrReferenceExpression && parent2 instanceof GrMethodCall && ((GrMethodCall)parent2).getInvokedExpression() == place;
    }

    public void closureInMethod(Map<Object, Object> args) {
        if (args == null) {
            return;
        }
        ClosureDescriptor descriptor = DescriptorsKt.parseClosure(args);
        if (descriptor == null) {
            return;
        }
        this.myDeclarations = this.myDeclarations.prepend((Object)descriptor);
    }

    public void variable(Map<Object, Object> args) {
        if (args == null) {
            return;
        }
        this.myDeclarations = this.myDeclarations.prepend((Object)DescriptorsKt.parseVariable(args));
    }

    @Nullable
    public Object methodMissing(String name, Object args) {
        Object[] newArgs = this.constructNewArgs((Object[])args);
        for (GdslMembersProvider provider2 : PROVIDERS) {
            List variants = DefaultGroovyMethods.getMetaClass((Object)provider2).respondsTo((Object)provider2, name, newArgs);
            if (variants.size() != 1) continue;
            return InvokerHelper.invokeMethod((Object)provider2, (String)name, (Object)newArgs);
        }
        return null;
    }

    @Nullable
    public Object propertyMissing(String name) {
        List list;
        if (this.myBindings != null && (list = this.myBindings.get(name)) != null) {
            return list;
        }
        return null;
    }
}

