/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.UtilKt;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dgm.DGMFileType;
import org.jetbrains.plugins.groovy.dgm.GroovyMacroModuleListener;
import org.jetbrains.plugins.groovy.dgm.GroovyMacroRegistryServiceImpl;
import org.jetbrains.plugins.groovy.dgm.GroovyMacroRegistryServiceImplKt;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.transformations.macro.GroovyMacroRegistryService;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\bJ\u0012\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R,\u0010\u0006\u001a \u0012\u0004\u0012\u00020\b\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/groovy/dgm/GroovyMacroRegistryServiceImpl;", "Lorg/jetbrains/plugins/groovy/transformations/macro/GroovyMacroRegistryService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "availableModules", "", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/psi/util/CachedValue;", "", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiMethod;", "getProject", "()Lcom/intellij/openapi/project/Project;", "dispose", "", "getAllKnownMacros", "", "context", "Lcom/intellij/psi/PsiElement;", "getModuleRegistry", "module", "refreshModule", "resolveAsMacro", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "intellij.groovy"})
public final class GroovyMacroRegistryServiceImpl
implements GroovyMacroRegistryService,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<Module, CachedValue<Set<SmartPsiElementPointer<PsiMethod>>>> availableModules;

    public GroovyMacroRegistryServiceImpl(@NotNull Project project) {
        this.project = project;
        this.availableModules = new ConcurrentHashMap();
        this.project.getMessageBus().connect().subscribe(WorkspaceModelTopics.CHANGED, (Object)new GroovyMacroModuleListener());
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public PsiMethod resolveAsMacro(@NotNull GrMethodCall call) {
        Object v6;
        block5: {
            void $this$filterTo$iv$iv;
            Object object;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)call);
            if (module == null) {
                return null;
            }
            Module module2 = module;
            GrExpression $this$asSafely$iv = call.getInvokedExpression();
            boolean $i$f$asSafely = false;
            GrExpression grExpression = $this$asSafely$iv;
            if (!(grExpression instanceof GrReferenceExpression)) {
                grExpression = null;
            }
            if ((object = (GrReferenceExpression)grExpression) == null || (object = object.getReferenceName()) == null) {
                return null;
            }
            Object invokedName = object;
            Iterable $this$filter$iv = this.getModuleRegistry(module2);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SmartPsiElementPointer it = (SmartPsiElementPointer)element$iv$iv;
                boolean bl = false;
                PsiMethod psiMethod = (PsiMethod)it.getElement();
                if (!Intrinsics.areEqual((Object)(psiMethod != null ? psiMethod.getName() : null), (Object)invokedName)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List candidates = (List)destination$iv$iv;
            iterable = candidates;
            for (Object t : iterable) {
                SmartPsiElementPointer it = (SmartPsiElementPointer)t;
                boolean bl = false;
                PsiMethod psiMethod = (PsiMethod)it.getElement();
                boolean bl2 = psiMethod != null ? GroovyMacroRegistryServiceImplKt.access$canBeAppliedTo(psiMethod, call) : false;
                if (!bl2) continue;
                v6 = t;
                break block5;
            }
            v6 = null;
        }
        SmartPsiElementPointer smartPsiElementPointer = v6;
        return smartPsiElementPointer != null ? (PsiMethod)smartPsiElementPointer.getElement() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PsiMethod> getAllKnownMacros(@NotNull PsiElement context) {
        void $this$mapNotNullTo$iv$iv;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        Iterable $this$mapNotNull$iv = this.getModuleRegistry(module2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiMethod it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            SmartPsiElementPointer it = (SmartPsiElementPointer)element$iv$iv;
            boolean bl2 = false;
            if ((PsiMethod)it.getElement() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void refreshModule(@NotNull Module module) {
        this.availableModules.remove(module);
    }

    private final Set<SmartPsiElementPointer<PsiMethod>> getModuleRegistry(Module module) {
        return (Set)this.availableModules.computeIfAbsent(module, arg_0 -> GroovyMacroRegistryServiceImpl.getModuleRegistry$lambda$3((Function1)new Function1<Module, CachedValue<Set<? extends SmartPsiElementPointer<PsiMethod>>>>(module){
            final /* synthetic */ Module $module;
            {
                this.$module = $module;
                super(1);
            }

            @NotNull
            public final CachedValue<Set<SmartPsiElementPointer<PsiMethod>>> invoke(@NotNull Module it) {
                CachedValue moduleRegistry = CachedValuesManager.getManager((Project)this.$module.getProject()).createCachedValue(() -> getModuleRegistry.1.invoke$lambda$2(this.$module));
                return moduleRegistry;
            }

            /*
             * WARNING - void declaration
             */
            private static final CachedValueProvider.Result invoke$lambda$2(Module $module) {
                void $this$mapTo$iv;
                PsiMethod extensionClass;
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)$module);
                Collection extensionFiles = FileTypeIndex.getFiles((FileType)((FileType)DGMFileType.INSTANCE), (GlobalSearchScope)scope);
                if (extensionFiles.isEmpty()) {
                    Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
                    return new CachedValueProvider.Result((Object)SetsKt.emptySet(), objectArray);
                }
                Set macroRegistry = new LinkedHashSet<E>();
                List extensionClassFiles = new ArrayList<E>();
                for (VirtualFile extensionVirtualFile : extensionFiles) {
                    void $this$filterTo$iv$iv;
                    PsiFile psi;
                    PsiFile $this$asSafely$iv = psi = PsiUtilBase.getPsiFile((Project)$module.getProject(), (VirtualFile)extensionVirtualFile);
                    boolean $i$f$asSafely = false;
                    PsiFile psiFile = $this$asSafely$iv;
                    if (!(psiFile instanceof PropertiesFile)) {
                        psiFile = null;
                    }
                    PropertiesFile propertiesFile = (PropertiesFile)psiFile;
                    Object inst = propertiesFile != null ? propertiesFile.findPropertyByKey("extensionClasses") : null;
                    Object object = inst;
                    if (object == null || (object = object.getValue()) == null) continue;
                    Object extensionClassName = object;
                    if (JavaPsiFacade.getInstance((Project)$module.getProject()).findClass((String)extensionClassName, scope) == null) continue;
                    UtilKt.addIfNotNull((List)extensionClassFiles, (Object)extensionClass.getContainingFile().getVirtualFile());
                    PsiMethod[] $this$filter$iv = extensionClass.getMethods();
                    boolean $i$f$filter = false;
                    PsiMethod[] psiMethodArray = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    int n = ((void)$this$filterTo$iv$iv).length;
                    for (int j = 0; j < n; ++j) {
                        void element$iv$iv;
                        void it = element$iv$iv = $this$filterTo$iv$iv[j];
                        boolean bl = false;
                        boolean bl2 = it.hasAnnotation("org.codehaus.groovy.macro.runtime.Macro") && it.getParameterList().getParameters()[0].getTypeElement() != null && it.getParameterList().getParameters()[0].getType().equalsToText("org.codehaus.groovy.macro.runtime.MacroContext");
                        if (!bl2) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List macroMethods = (List)destination$iv$iv;
                    macroRegistry.addAll(macroMethods);
                }
                Object object = macroRegistry;
                Collection destination$iv = new HashSet<E>();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    extensionClass = (PsiMethod)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(SmartPointerManager.createPointer((PsiElement)((PsiElement)it)));
                }
                object = new SpreadBuilder(2);
                Collection $this$toTypedArray$iv = extensionFiles;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                object.addSpread((Object)thisCollection$iv.toArray(new VirtualFile[0]));
                $this$toTypedArray$iv = extensionClassFiles;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                object.addSpread((Object)thisCollection$iv.toArray(new VirtualFile[0]));
                Object[] objectArray = object.toArray(new Object[object.size()]);
                Collection collection = destination$iv;
                return new CachedValueProvider.Result((Object)collection, objectArray);
            }
        }, arg_0)).getValue();
    }

    public void dispose() {
        this.availableModules.clear();
    }

    private static final CachedValue getModuleRegistry$lambda$3(Function1 $tmp0, Object p0) {
        return (CachedValue)$tmp0.invoke(p0);
    }
}

