/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrGdkMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

public final class GdkMethodHolder {
    private static final Key<CachedValue<GdkMethodHolder>> CACHED_NON_STATIC = Key.create((String)"Cached instance gdk method holder");
    private static final Key<CachedValue<GdkMethodHolder>> CACHED_STATIC = Key.create((String)"Cached static gdk method holder");
    private final String myClassName;
    private final ConcurrentMap<String, MultiMap<String, PsiMethod>> myOriginalMethodsByNameAndType;
    private final NotNullLazyValue<MultiMap<String, PsiMethod>> myOriginalMethodByType;
    private final boolean myStatic;

    private GdkMethodHolder(PsiClass categoryClass, boolean isStatic) {
        this.myClassName = categoryClass.getName();
        this.myStatic = isStatic;
        MultiMap byName = new MultiMap();
        for (PsiMethod m : categoryClass.getMethods()) {
            PsiParameter[] params = m.getParameterList().getParameters();
            if (params.length == 0 || params[0].getType() instanceof PsiPrimitiveType || !m.hasModifierProperty("public") || !m.hasModifierProperty("static") || PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)m) || PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)m)) continue;
            byName.putValue((Object)m.getName(), (Object)m);
        }
        this.myOriginalMethodByType = NotNullLazyValue.volatileLazy(() -> GdkMethodHolder.groupByType(byName.values()));
        this.myOriginalMethodsByNameAndType = ConcurrentFactoryMap.createMap(name -> GdkMethodHolder.groupByType(byName.get(name)));
    }

    @NotNull
    private static MultiMap<String, PsiMethod> groupByType(Collection<? extends PsiMethod> methods) {
        MultiMap map2 = new MultiMap();
        for (PsiMethod psiMethod : methods) {
            PsiType type2 = GdkMethodHolder.getCategoryTargetType(psiMethod);
            if (type2 == null) continue;
            map2.putValue((Object)type2.getCanonicalText(), (Object)psiMethod);
        }
        return map2;
    }

    @Nullable
    private static PsiType getCategoryTargetType(@NotNull PsiMethod method) {
        PsiType parameterType = method.getParameterList().getParameters()[0].getType();
        return TypeConversionUtil.erasure((PsiType)parameterType);
    }

    public boolean processMethods(PsiScopeProcessor processor, @NotNull ResolveState state, PsiType qualifierType, Project project) {
        MultiMap map2;
        if (qualifierType == null) {
            return true;
        }
        if (state.get(ClassHint.STATIC_CONTEXT) == Boolean.TRUE && !this.myStatic) {
            return true;
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String name = nameHint == null ? null : nameHint.getName(state);
        MultiMap multiMap = map2 = name != null ? (MultiMap)this.myOriginalMethodsByNameAndType.get(name) : (MultiMap)this.myOriginalMethodByType.getValue();
        if (map2.isEmpty()) {
            return true;
        }
        for (String superType : ResolveUtil.getAllSuperTypes(qualifierType, project)) {
            for (PsiMethod method : map2.get((Object)superType)) {
                String info;
                GrGdkMethod gdk = GrGdkMethodImpl.createGdkMethod(method, this.myStatic, info = GdkMethodUtil.generateOriginInfo(method));
                if (processor.execute((PsiElement)gdk, state)) continue;
                return false;
            }
        }
        return true;
    }

    public static GdkMethodHolder getHolderForClass(PsiClass categoryClass, boolean isStatic) {
        Project project = categoryClass.getProject();
        Key<CachedValue<GdkMethodHolder>> key = isStatic ? CACHED_STATIC : CACHED_NON_STATIC;
        return (GdkMethodHolder)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)categoryClass, key, () -> {
            GdkMethodHolder result2 = new GdkMethodHolder(categoryClass, isStatic);
            ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
            VirtualFile vfile = categoryClass.getContainingFile().getVirtualFile();
            if (vfile != null && rootManager.getFileIndex().isInLibrary(vfile)) {
                return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{rootManager});
            }
            return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, rootManager});
        }, false);
    }

    @NonNls
    public String toString() {
        return "GDK Method Holder for " + this.myClassName;
    }
}

