/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dgm.DGMUtil;

public class DGMReferenceContributor
extends PsiReferenceContributor {
    private final JavaClassReferenceProvider myProvider = new JavaClassReferenceProvider();

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar2) {
        registrar2.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement((IElementType)PropertiesTokenTypes.VALUE_CHARACTERS), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (!DGMUtil.isInDGMFile(element)) {
                    return PsiReference.EMPTY_ARRAY;
                }
                IProperty parent2 = (IProperty)element.getParent();
                if (!"extensionClasses".equals(parent2.getName())) {
                    return PsiReference.EMPTY_ARRAY;
                }
                ArrayList result2 = new ArrayList();
                String text = element.getText();
                int i2 = 0;
                while ((i2 = DGMReferenceContributor.skipWhiteSpace(i2, text)) < text.length()) {
                    int end = DGMReferenceContributor.findWhiteSpaceOrComma(i2, text);
                    if (end <= text.length()) {
                        JavaClassReferenceSet set = new JavaClassReferenceSet(text.substring(i2, end), element, i2, true, DGMReferenceContributor.this.myProvider);
                        ContainerUtil.addAll(result2, (Object[])set.getAllReferences());
                    }
                    i2 = end;
                    if ((i2 = DGMReferenceContributor.skipWhiteSpace(i2, text)) == text.length()) break;
                    if (text.charAt(i2) == ',') {
                        ++i2;
                    }
                    i2 = DGMReferenceContributor.skipWhiteSpace(i2, text);
                }
                return result2.toArray(PsiReference.EMPTY_ARRAY);
            }
        });
    }

    private static int skipWhiteSpace(int i2, String text) {
        while (i2 < text.length() && Character.isWhitespace(text.charAt(i2))) {
            ++i2;
        }
        return i2;
    }

    private static int findWhiteSpaceOrComma(int i2, String text) {
        while (i2 < text.length() && !Character.isWhitespace(text.charAt(i2)) && text.charAt(i2) != ',') {
            ++i2;
        }
        return i2;
    }
}

