/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dgm.GdkMethodHolder;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyCommonClassNames;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.transformations.macro.GroovyMacroRegistryService;

public final class DGMMemberContributor {
    public static boolean processDgmMethods(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        GlobalSearchScope scope;
        if (!ResolveUtil.shouldProcessMethods((ElementClassHint)processor.getHint(ElementClassHint.KEY))) {
            return true;
        }
        Project project = place.getProject();
        ConcurrentMap map2 = (ConcurrentMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ConcurrentMap value2 = ContainerUtil.createConcurrentSoftValueMap();
            return CachedValueProvider.Result.create((Object)value2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        List<GdkMethodHolder> gdkMethods = (List<GdkMethodHolder>)map2.get(scope = place.getResolveScope());
        if (gdkMethods == null) {
            gdkMethods = DGMMemberContributor.calcGdkMethods(project, scope);
            map2.put(scope, gdkMethods);
        }
        for (GdkMethodHolder holder : gdkMethods) {
            if (holder.processMethods(processor, state, qualifierType, project)) continue;
            return false;
        }
        return DGMMemberContributor.resolvesToMacro(processor, state, place, project);
    }

    private static boolean resolvesToMacro(PsiScopeProcessor processor, ResolveState state, @NotNull PsiElement place, Project project) {
        String name;
        GroovyMacroRegistryService macroService = (GroovyMacroRegistryService)project.getService(GroovyMacroRegistryService.class);
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String string = name = nameHint == null ? null : nameHint.getName(state);
        if (name == null) {
            return true;
        }
        List<PsiMethod> macros = macroService.getAllKnownMacros(place);
        for (PsiMethod macro : macros) {
            if (processor.execute((PsiElement)GdkMethodUtil.createMacroMethod(macro), state)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<GdkMethodHolder> calcGdkMethods(Project project, GlobalSearchScope resolveScope) {
        PsiClass clazz;
        ArrayList<GdkMethodHolder> gdkMethods = new ArrayList<GdkMethodHolder>();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        Couple<List<String>> extensions = DGMMemberContributor.collectExtensions(project, resolveScope);
        for (String category : (List)extensions.getFirst()) {
            clazz = facade.findClass(category, resolveScope);
            if (clazz == null) continue;
            gdkMethods.add(GdkMethodHolder.getHolderForClass(clazz, false));
        }
        for (String category : (List)extensions.getSecond()) {
            clazz = facade.findClass(category, resolveScope);
            if (clazz == null) continue;
            gdkMethods.add(GdkMethodHolder.getHolderForClass(clazz, true));
        }
        return gdkMethods;
    }

    @NotNull
    private static Couple<List<String>> collectExtensions(@NotNull Project project, @NotNull GlobalSearchScope resolveScope) {
        ArrayList<String> instanceClasses = new ArrayList<String>(GroovyCommonClassNames.DEFAULT_INSTANCE_EXTENSIONS);
        ArrayList<String> staticClasses = new ArrayList<String>(GroovyCommonClassNames.DEFAULT_STATIC_EXTENSIONS);
        DGMMemberContributor.doCollectExtensions(project, resolveScope, instanceClasses, staticClasses, "META-INF.groovy");
        DGMMemberContributor.doCollectExtensions(project, resolveScope, instanceClasses, staticClasses, "META-INF.services");
        return Couple.of(instanceClasses, staticClasses);
    }

    private static void doCollectExtensions(@NotNull Project project, @NotNull GlobalSearchScope resolveScope, @NotNull List<String> instanceClasses, @NotNull List<String> staticClasses, @NlsSafe @NotNull String packageName) {
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
        if (aPackage == null) {
            return;
        }
        for (PsiDirectory directory : aPackage.getDirectories(resolveScope)) {
            PsiFile file = directory.findFile("org.codehaus.groovy.runtime.ExtensionModule");
            if (!(file instanceof PropertiesFile)) continue;
            AstLoadingFilter.forceAllowTreeLoading((PsiFile)file, () -> {
                IProperty inst = ((PropertiesFile)file).findPropertyByKey("extensionClasses");
                IProperty stat = ((PropertiesFile)file).findPropertyByKey("staticExtensionClasses");
                if (inst != null) {
                    DGMMemberContributor.collectClasses(inst, instanceClasses);
                }
                if (stat != null) {
                    DGMMemberContributor.collectClasses(stat, staticClasses);
                }
            });
        }
    }

    private static void collectClasses(@NotNull IProperty pr, @NotNull List<String> classes2) {
        String value2 = pr.getUnescapedValue();
        if (value2 == null) {
            return;
        }
        value2 = value2.trim();
        Object[] qnames = value2.split("\\s*,\\s*");
        ContainerUtil.addAll(classes2, (Object[])qnames);
    }
}

